/*************************************************
* RSA Header File                                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_RSA_H__
#define BOTAN_RSA_H__

#include <botan/bigint.h>
#include <botan/pk_keys.h>
#include <botan/mod_exp.h>

namespace Botan {

/*************************************************
* RSA Public Key                                 *
*************************************************/
class RSA_PublicKey : public PK_Encrypting_Key, public PK_Verifying_with_MR_Key
   {
   public:
      SecureVector<byte> encrypt(const byte[], u32bit) const;
      SecureVector<byte> verify(const byte[], u32bit) const;

      u32bit max_input_bits() const { return (n.bits() - 1); }

      const BigInt& get_n() const { return n; }
      const BigInt& get_e() const { return e; }

      RSA_PublicKey(const BigInt&, const BigInt&);
   protected:
      RSA_PublicKey() {}
      BigInt public_op(const BigInt&) const;
      BigInt n, e;
      FixedExponent_Exp powermod_e_n;
   };

/*************************************************
* RSA Private Key                                *
*************************************************/
class RSA_PrivateKey : public RSA_PublicKey, public PK_Decrypting_Key,
                       public PK_Signing_Key
   {
   public:
      SecureVector<byte> decrypt(const byte[], u32bit) const;
      SecureVector<byte> sign(const byte[], u32bit) const;

      bool check_params() const;
      const BigInt& get_p() const { return p; }
      const BigInt& get_q() const { return q; }
      const BigInt& get_d() const { return d; }

      RSA_PrivateKey(const BigInt&, const BigInt&, const BigInt&,
                     const BigInt& = 0, const BigInt& = 0);
      RSA_PrivateKey(u32bit, const BigInt& = 65537);
   private:
      BigInt private_op(const BigInt&) const;
      void precompute();
      BigInt d, p, q, d1, d2, c;
      FixedExponent_Exp powermod_d1_p, powermod_d2_q;
   };

}

#endif
