/*************************************************
* Serpent Header File                            *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SERPENT_H__
#define BOTAN_SERPENT_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* Serpent                                        *
*************************************************/
class Serpent : public BlockCipher
   {
   public:
      void clear() throw() { round_key.clear(); }
      std::string name() const { return "Serpent"; }
      BlockCipher* clone() const { return new Serpent; }
      Serpent() : BlockCipher(16, 16, 32, 8) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void key_xor(u32bit, u32bit&, u32bit&, u32bit&, u32bit&) const;
      static void SBoxE1(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE2(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE3(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE4(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE5(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE6(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE7(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxE8(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD1(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD2(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD3(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD4(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD5(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD6(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD7(u32bit&, u32bit&, u32bit&, u32bit&);
      static void SBoxD8(u32bit&, u32bit&, u32bit&, u32bit&);
      static void transform(u32bit&, u32bit&, u32bit&, u32bit&);
      static void i_transform(u32bit&, u32bit&, u32bit&, u32bit&);
      SecureBuffer<u32bit, 132> round_key;
   };

}

#endif
