/*************************************************
* SymmetricKey Header File                       *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SYMKEY_H__
#define BOTAN_SYMKEY_H__

#include <botan/secmem.h>
#include <string>

namespace Botan {

/*************************************************
* SymmetricKey                                   *
*************************************************/
class SymmetricKey
   {
   public:
      operator const byte* () const { return key; }
      u32bit length() const { return key.size(); }

      SymmetricKey& operator^=(const SymmetricKey&);

      SecureVector<byte> copy() const { return key; }
      const SecureVector<byte>& value() const { return key; }

      void change(const std::string&);
      void change(const byte[], u32bit);
      void change(u32bit);
      void change(const SecureVector<byte>& v) { key = v; }

      SymmetricKey(const std::string& str = "") { change(str); }
      SymmetricKey(const byte in[], u32bit len) { change(in, len); }
      SymmetricKey(u32bit length) { change(length); }
      SymmetricKey(const SecureVector<byte>& v) { change(v); }
   private:
      SecureVector<byte> key;
   };

/*************************************************
* XOR Operation for SymmetricKeys                *
*************************************************/
SymmetricKey operator^(const SymmetricKey&, const SymmetricKey&);

typedef SymmetricKey BlockCipher_Key;
typedef SymmetricKey StreamCipher_Key;
typedef SymmetricKey MAC_Key;

}

#endif
