/*************************************************
* Tiger Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_TIGER_H__
#define BOTAN_TIGER_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* Tiger                                          *
*************************************************/
class Tiger : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "Tiger"; }
      HashFunction* clone() const { return new Tiger; }
      Tiger() : MDx_HashFunction(24, 64) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void round(u64bit&, u64bit&, u64bit&, u64bit, u32bit);
      static const u64bit SBOX1[256], SBOX2[256], SBOX3[256], SBOX4[256];
      SecureBuffer<u64bit, 8> X;
      SecureBuffer<u64bit, 3> digest;
   };

}

#endif
