#!/bin/sh
#
#	Copyright (c)2001 Grumbler
#
# $Id: trafd.sh,v 1.6 2001/12/02 19:47:35 stas Exp $
#
# $Log: trafd.sh,v $
# Revision 1.6  2001/12/02 19:47:35  stas
# Add pathnames to all executables.
# Remove kill -hup, change kill -term to kill -quit
#
# Revision 1.5  2001/12/02 09:24:08  stas
# Add iface check & message: Not an interface for listen!
#
# Revision 1.4  2001/10/28 05:27:03  stas
# Add rc.conf launch
#
# Revision 1.3  2001/09/06 11:24:22  stas
# Logging start action.
#
# Revision 1.2  2001/09/03 08:15:23  stas
# Add IFF_LISTEN env.variable support.
#
# Revision 1.1  2001/09/03 02:13:30  stas
# Initial revision
#
#
#
# if $1=='start': start of the network traffic collector
# if $1=='stop' : dump all records to /var/tmp/trafd.$iface
#		and shutdown network traffic collector ('kill')
#
# !!! ALERT !!!
# set the "IFF_LISTEN" enviroment variable to REAL interface name
#

. /etc/rc.conf

# Interface for traffic accounting

if [ "${IFF_LISTEN}" ] ; then
	ifaces="${IFF_LISTEN}"
else
#	iface="`/sbin/ifconfig -lu | /usr/bin/sed s/\ .*//`"  # 1st iface in list
	ifaces="`/sbin/ifconfig -lu | /usr/bin/sed s/lo0//`"	# all ifaces except loopback (lo0)
fi

if [ ! "${ifaces}" ] ; then
	/bin/echo "Not an interface for listen!"
	/bin/echo `/bin/date +"%b %e %H:%M:%S"` `/bin/hostname -s` trafd.sh: Not an interface for listen!
	exit -1
fi


WHERE_PID=/var/run/trafd.
LOG_FILE=/var/log/trafd.log

case $1 in
start)
	for iface in $ifaces; do
	  /usr/local/sbin/trafd -pri $iface && /bin/echo " trafd (${iface}) "
	  if [ $? = 0 ]; then
	    /bin/echo `/bin/date +"%b %e %H:%M:%S"` `/bin/hostname -s` trafd.sh: '('$iface')' started >> $LOG_FILE
	  fi
	done
        ;;
stop)
	for iface in $ifaces; do
	  PID_FILE=$WHERE_PID$iface
	  if [ -f $PID_FILE ]; then
	    PID="`cat $PID_FILE`"
	    /bin/kill -QUIT ${PID}
	    if [ $? = 0 ]; then
		/bin/echo `/bin/date +"%b %e %H:%M:%S"` `/bin/hostname -s` trafd.sh: '('$iface')' signaling to shutdown >> $LOG_FILE
	    fi
	  else
	    if [ ! -d $LOG_FILE -a -w $LOG_FILE ]; then
		/bin/echo "`/bin/date +"%b %e %H:%M:%S"` `/bin/hostname -s` trafd.sh: (stop) error: $PID_FILE not found" | /usr/bin/tee -a $LOG_FILE
	    else
		/bin/echo "`/bin/date +"%b %e %H:%M:%S"` `/bin/hostname -s` trafd.sh: (stop) warning: $PID_FILE not found"
	    fi
	  fi
	done
        ;;
*)
        /bin/echo "Usage: `/usr/bin/basename $0` {start|stop}" >&2
        exit 64
        ;;
esac

exit 0

