#	$Id: bt.inc.mk,v 1.3 2003/02/03 16:52:31 jmmv Exp $
#	$NetBSD: bsd.inc.mk,v 1.22 2002/02/11 21:14:58 mycroft Exp $

# --------------------------------------------------------------------
# Basic targets
# --------------------------------------------------------------------
.PHONY:		_incinstall _incdeinstall
includes:	${BT_INCS} _incinstall
real-install:	_incinstall
real-deinstall:	_incdeinstall

# --------------------------------------------------------------------
# Installation
# --------------------------------------------------------------------
_incinstall::	# ensure existence

__incinstall: .USE
.if !exists(${BT_DIR_INCLUDE})
	@${BT_INSTALL_DIR} ${BT_DIR_INCLUDE}
.endif
	@dir=`dirname ${.TARGET}` && \
	    if [ ! -d "$$dir" ]; then \
	    ${BT_INSTALL_DIR} $$dir; fi
	@${BT_INSTALL_DATA} ${.ALLSRC} ${.TARGET}

.for _F in ${BT_INCS:O:u}
_FDIR:=		${BT_INCSDIR_${_F:C,/,_,g}:U${BT_INCSDIR}}	# dir override
_FNAME:=	${BT_INCSNAME_${_F:C,/,_,g}:U${BT_INCSNAME:U${_F}}} # name override
__F:=		${BT_DIR_INCLUDE}/${_FDIR}/${_FNAME}	# installed path

${__F}!		${_F} __incinstall			# install rule

_incinstall::	${__F}
_INSTINC+=	${__F}
.PRECIOUS:	${__F}					# keep if install fails
.endfor

# --------------------------------------------------------------------
# Deinstallation
# --------------------------------------------------------------------

_incdeinstall:
.for _F in ${_INSTINC}
.if exists(${_F})
	rm -f ${_F}
.endif
.endfor

.if !defined(BT_PROG) && !defined(BT_LIB) && !defined(BT_SRCS)
.include <bt.clean.mk>
.endif
