# $Id: bt.init.mk,v 1.17 2003/02/03 16:21:21 jmmv Exp $

.if !defined(__BT_INIT_MK)
__BT_INIT_MK= 1

# Include system-wide configuration file, if found.
.-include "${BTOWN_DIR_CONF}/bt_make.conf"

# List of files to clean.
BT_FILES_CLEAN?=
BT_FILES_CLEANDIR?=

# Try to guess top directory, if not specified already. We MUST know
# it to work properly!
.if !defined(BT_TOPDIR)
BT_TOPDIR!=	cd ${.CURDIR}; while :; do \
		here=`pwd`; \
		[ -d buildtool.d ] && { echo $$here; break; }; \
		case $$here in /) echo ""; break;; esac; \
		cd ..; done
.endif

# Check for REQUIRED bt_config.mk presence.
.if exists(${BT_TOPDIR}/bt_config.mk)
.    include "${BT_TOPDIR}/bt_config.mk"
.else
.    abort bt_config.mk not found, use "buildtool config" first.
.endif

# Include common Makefile, if found.
.-include "${.CURDIR}/../Makefile.inc"

BT_LOGIC=		env ${BT_LOGIC_ENV} ${BTOWN_DIR_MODS}/bt_logic
BT_LOGIC_ENV+=		BT_TOPDIR="${BT_TOPDIR}"
BT_FILES_CLEAN+=	bt_logic.log bt_run

BT_INSTALL_BIN=		${BT_LOGIC} install-bin
BT_INSTALL_DIR=		${BT_LOGIC} install-dir
BT_INSTALL_DATA=	${BT_LOGIC} install-data
BT_INSTALL_LIB=		${BT_LOGIC} install-lib
# XXX: must be install-symlink
BT_INSTALL_SYMLINK=	ln -s

# --------------------------------------------------------------------
# Targets
# --------------------------------------------------------------------

# Common targets.
BT_TARGETS+=	all clean cleandir deinstall depend install obj
.PHONY:		all clean cleandir deinstall depend install obj

# Internal targets (those that the user should not call directly).
.PHONY:		real-deinstall pre-deinstall post-deinstall \
		real-depend    pre-depend    post-depend \
		real-install   pre-install   post-install \
		real-all \
		subdir-all subdir-deinstall \
		subdir-depend subdir-install

# Install-related targets
.if !target(install)
install:		.NOTMAIN pre-install subdir-install \
			         real-install post-install
pre-install:		.NOTMAIN
subdir-install:		.NOTMAIN pre-install
real-install:		.NOTMAIN pre-install
post-install:		.NOTMAIN subdir-install real-install
.endif

# Deinstall-related targets
.if !target(deinstall)
deinstall:		.NOTMAIN pre-deinstall subdir-deinstall \
			         real-deinstall post-deinstall
pre-deinstall:		.NOTMAIN
subdir-deinstall:	.NOTMAIN pre-deinstall
real-deinstall:		.NOTMAIN pre-deinstall
post-deinstall:		.NOTMAIN subdir-deinstall real-deinstall
.endif

# Other important targets
all:		.NOTMAIN real-all subdir-all
subdir-all:	.NOTMAIN
real-all:	.NOTMAIN
depend:		.NOTMAIN real-depend subdir-depend
subdir-depend:	.NOTMAIN
real-depend:	.NOTMAIN
distclean:	.NOTMAIN cleandir
cleandir:	.NOTMAIN clean
clean:		.NOTMAIN

# Force our main target to be "all".
.MAIN:		all

.endif		# __BT_INIT_MK
