#	$Id: bt.lib.mk,v 1.23 2003/02/04 19:25:53 jmmv Exp $
#	$NetBSD: bsd.lib.mk,v 1.205 2002/07/20 08:50:10 yamt Exp $
#	@(#)bsd.lib.mk	8.3 (Berkeley) 4/22/94

.include <bt.init.mk>

.SUFFIXES: .c .cc .cpp .o .h .sh .m4 .y .s .S .so .a .po

# --------------------------------------------------------------------
# Basic targets
# --------------------------------------------------------------------

.PHONY:		_libinstall _libdeinstall
real-install:	_libinstall
real-deinstall:	_libdeinstall

BT_LOGIC_ENV+=	BT_LOGIC_MKSTATIC="${BT_LIB_MKSTATIC}"
BT_LOGIC_ENV+=	BT_LOGIC_MKPIC="${BT_LIB_MKPIC}"

# Set ${BT_LIB_VERSION} to something useful.
.if !defined(BT_LIB_VERSION)
.if defined(BT_LIB_MAJOR) && !empty(BT_LIB_MAJOR)
.if defined(BT_LIB_MINOR) && !empty(BT_LIB_MINOR)
.if defined(BT_LIB_MICRO) && !empty(BT_LIB_MICRO)
BT_LIB_VERSION=${BT_LIB_MAJOR}.${BT_LIB_MINOR}.${BT_LIB_MICRO}
.else
BT_LIB_VERSION=${BT_LIB_MAJOR}.${BT_LIB_MINOR}
.endif
.else
BT_LIB_VERSION=${BT_LIB_MAJOR}
.endif
.endif
.endif

_LIBNAME=	lib${BT_LIB}.btl

# --------------------------------------------------------------------
# Implicit conversions
# --------------------------------------------------------------------

# Archive objects

.c.o .c.po:
	@${BT_LOGIC} compile-lib cc ${BT_FLAGS_CPP} ${BT_FLAGS_CC} \
	    -c ${.IMPSRC} -o ${.TARGET}

.cc.o .cc.po:
	@${BT_LOGIC} compile-lib c++ ${BT_FLAGS_CPP} ${BT_FLAGS_CXX} \
	    -c ${.IMPSRC} -o ${.TARGET}

.cpp.o .cpp.po:
	@${BT_LOGIC} compile-lib c++ ${BT_FLAGS_CPP} ${BT_FLAGS_CXX} \
	    -c ${.IMPSRC} -o ${.TARGET}


# --------------------------------------------------------------------
# Main targets
# --------------------------------------------------------------------

# Default sources if not defined.
.if defined(BT_LIB)
BT_SRCS?=	${BT_LIB}.c
.endif

# Determine object files.
.if !empty(BT_SRCS:N*.h)
BT_OBJS+=	${BT_SRCS:N*.h:R:S/$/.o/g}
BT_POBJS+=	${BT_SRCS:N*.h:R:S/$/.po/g}
.endif

# Determine which compiler to use as linker.
.if !empty(BT_SRCS:M*.cc) || !empty(BT_SRCS:M*.cpp)
_CMD_LINK=	c++
.else
_CMD_LINK=	cc
.endif # !empty(BT_SRCS:M*.cc) || !empty(BT_SRCS:M*.cpp)

.if defined(BT_OBJS) && !empty(BT_OBJS)
.NOPATH: ${BT_OBJS} ${_LIBNAME} ${BT_SRCS:C/\..$/.c/}

_OBJS=
.if ${BT_LIB_MKSTATIC} == "yes"
_OBJS+=		${BT_OBJS}
.endif
.if ${BT_LIB_MKPIC} == "yes"
_OBJS+=		${BT_POBJS}
.endif
${_LIBNAME}: ${_OBJS}
	@${BT_LOGIC} link-lib ${_CMD_LINK} ${BT_FLAGS_LD} \
		-o ${_LIBNAME} ${BT_OBJS} ${BT_LIBS} \
		-version-info ${BT_LIB_VERSION}
.endif

real-all: depend ${_LIBNAME}

# --------------------------------------------------------------------
# Installation
# --------------------------------------------------------------------

_libinstall::	${BT_DIR_LIB}/${_LIBNAME}
.PRECIOUS:	${BT_DIR_LIB}/${_LIBNAME}
${BT_DIR_LIB}/${_LIBNAME}! ${_LIBNAME}
.if !exists(${BT_DIR_LIB})
	@${BT_INSTALL_DIR} ${BT_DIR_LIB}
.endif
	@${BT_INSTALL_LIB} ${_LIBNAME} ${BT_DIR_LIB}

# --------------------------------------------------------------------
# Deinstallation
# --------------------------------------------------------------------

.if !target(_libdeinstall)
_libdeinstall::
.if exists(${BT_DIR_LIB}/${_NAMESTATIC})
	rm -f ${BT_DIR_LIB}/${_NAMESTATIC}
.endif
.if exists(${BT_DIR_LIB}/${_NAMEPIC})
	rm -f ${BT_DIR_LIB}/${_NAMEPIC}
.endif
.if exists(${BT_DIR_LIB}/${_NAMEPIC_MAJOR})
	rm -f ${BT_DIR_LIB}/${_NAMEPIC_MAJOR}
.endif
.endif


BT_FILES_CLEAN+= a.out [Ee]rrs mklog core *.core
BT_FILES_CLEAN+= ${_LIBNAME:S/.btl$/.*/} ${BT_OBJS} ${BT_POBJS}

.include <bt.man.mk>
.include <bt.dep.mk>
.include <bt.clean.mk>

${TARGETS}:	# ensure existence
