#	$Id: bt.man.mk,v 1.5 2002/09/09 16:45:42 jmmv Exp $
#	$NetBSD: bsd.man.mk,v 1.78 2002/02/11 21:15:00 mycroft Exp $
#	@(#)bsd.man.mk	8.1 (Berkeley) 6/8/93

.include <bt.init.mk>

# --------------------------------------------------------------------
# Basic targets
# --------------------------------------------------------------------

.PHONY:		_maninstall _mandeinstall
real-install:	_maninstall
real-deinstall:	_mandeinstall

BT_MAN?=
_MNUMBERS=	1 2 3 4 5 6 7 8 9
.SUFFIXES:	${_MNUMBERS:@N@.$N@}

# --------------------------------------------------------------------
# Installation
# --------------------------------------------------------------------

__installpage: .USE
.if !exists(${BT_DIR_MAN})
	${BT_INSTALL_DIR} ${BT_DIR_MAN}
.endif
	@if [ ! -d ${.TARGET:H} ]; then \
	    echo "${BT_INSTALL_DIR} ${.TARGET:H}"; \
	    ${BT_INSTALL_DIR} ${.TARGET:H}; \
	fi
	${BT_INSTALL_DATA} ${.ALLSRC} ${.TARGET}

_MANSUFFIX=

.if !empty(BT_MAN)
_maninstall:
_MANPAGES=	${BT_MAN:C/.$/&${_MANSUFFIX}/}

.for _F in ${_MANPAGES:O:u}
__F:=		${BT_DIR_MAN}/man${_F:T:E}/${_F}

${__F}!		${_F} __installpage	# install rule

_INSTMAN+=	${__F}
_maninstall:	${__F}
.PRECIOUS:	${__F}			# keep if install fails
.endfor

.endif # !empty(BT_MAN)

# --------------------------------------------------------------------
# Deinstallation
# --------------------------------------------------------------------

_mandeinstall:
.for _F in ${_INSTMAN}
.if exists(${_F})
	rm -f ${_F}
.endif
.endfor

.if !defined(BT_PROG) && !defined(BT_LIB) && !defined(BT_SRCS)
.include <bt.clean.mk>
.endif

${TARGETS} _maninstall _mandeinstall: # ensure existence
