#!/usr/bin/perl
#  desc-pie.pl - Graph pie chart of expenses by description inside given 
#                category
#
#  Modidied by Alexandr E. Bravo (abravo@tctube.spb.su)
#
#  Modified by Arlindo L. Oliveira (aml@inesc.pt)
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: desc-pie.pl,v 1.1.1.1 1999/12/18 02:06:42 curt Exp $


package CBB;

use strict;    # don't take no guff


my($tmp, $temp, $cbb_incl_dir);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($credit_total, $debit_total, $amt, $lkey, $lcat, $subtotal);
my($ldesc, %subtotal);
my($tcom, $tamt, $tcat);
my(@keys, %ALLTRANS, @splits);
my($graphpath, $account, $name, $result);

# specify the installed location of the necessary pieces.
BEGIN {
$CBB::cbb_incl_dir = "/usr/local/lib/cbb";
unshift(@INC, $CBB::cbb_incl_dir);
}

$graphpath = "/usr/local/lib/cbb/graphs";

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";

($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] accounts";


# process arguments

my($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

my(%tmp_cat) = ();
my(%tmp_desc)= ();

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

            $ALLTRANS{"$key$name"} = $result;

            if ( substr($cat, 0, 1) ne "|" ) {
		$tmp_desc{desc} .= $cat . "," . $amt . ",";
		$tmp_cat{$cat} .= "$key$name" . "," . $amt . ",";
            } else {
                # process split

                @splits = split(/\|/, $cat);
                shift(@splits);

                $tmp = 0;
                while ( $#splits >= 0 ) {
                    $tcat = shift(@splits);
                    $tcom = shift(@splits);
                    $tamt = shift(@splits);

                    $tmp += $tamt;

                    # print "processing $tcat $tamt\n";
                    $tmp_cat{$tcat} .= "$key$name" . "," . $tamt . ",";
                    $tmp_desc{"$desc"} .= $tcat . "," . $tamt . ",";
                }
                if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
                    printf("WARNING:  Incorrect splits in $date: $desc\n");
                    printf("    %.2f != %.2f\n\n", $tmp, $amt);
                }
            }
        }

        $result = &next_trans();
    }
}


$credit_total = 0.00;
$debit_total = 0.00;

if ( ! -x "$graphpath/descpie") {
    die "Cannot launch $graphpath/descpie\n";
}

open(DATA,"| $graphpath/descpie") || die "Cannot launch graph\n";

foreach $lcat (sort keys(%tmp_cat)) {
    
    chop($tmp_cat{$lcat});  # Delete final comma

    @keys = split(/,/, $tmp_cat{$lcat});

    $subtotal = 0.00;

    while ( $#keys >= 0 ) {
        $lkey = shift(@keys);
        $amt  = shift(@keys);

        $result = $ALLTRANS{$lkey};

        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $subtotal = $subtotal + $amt;
        if ( $amt > 0 ) {
            $credit_total = $credit_total + $amt;
        } else {
            $debit_total = $debit_total + $amt;
        }
    }

    $lcat =~ s/ /-/g;
    $lcat eq "" and $lcat="<empty>";
    print DATA "$lcat $subtotal\n";
    # print  "$lcat $subtotal\n";
    # printf(" = %9.2f\n", $subtotal);
}

    print DATA "!\n";
#    print  "!\n";

foreach $ldesc (sort keys(%tmp_desc)) {
    
    chop($tmp_desc{$ldesc});  # Delete final comma

    @keys = split(/,/, $tmp_desc{$ldesc});

    %subtotal = ();

    while ( $#keys >= 0 ) {
        $lcat  = shift(@keys);
        $amt   = shift(@keys);

	$lcat =~ s/ /-/g;
	$lcat eq "" and $lcat="<empty>";
	$subtotal{$lcat} += $amt;
    }

    $ldesc =~ s/ /-/g;
    $ldesc eq "" and $ldesc="<empty>";

    foreach $lcat (sort keys(%subtotal)) {
      $amt = $subtotal{$lcat};
      print DATA "$lcat $ldesc $amt\n";
      # print  "$lcat $ldesc $amt\n";
    }
}


close(DATA);
