#!wish8.2 -f
#  'CBB' -- Check Book Balancer
#
#   help.tcl -- help routines
#
#  Written by Curtis Olson.  Started December 7, 1996.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: help.tcl,v 1.3 1999/12/18 13:49:28 curt Exp $


#------------------------------------------------------------------------------
# Help menu procedures
#------------------------------------------------------------------------------

proc cbbWindow.aboutwin name {
    global cbb lib_path

    if {[winfo exists .aboutwin] == 1} {
	wm withdraw .aboutwin
        wm deiconify .aboutwin
	return                
    }

    option add *font $cbb(msg_text_font)
    
    toplevel .aboutwin

    wm title .aboutwin "About $name"
    wm iconname .aboutwin "About $name"
    frame .aboutwin.frame -borderwidth 2 -relief raised
    frame .aboutwin.frame.a -borderwidth 2
    frame .aboutwin.frame.d -borderwidth 2

    # image create photo "splash1" -file "$lib_path/images/splash-32.gif"
    label .aboutwin.frame.a.but -image splash -bd 1 -relief sunken
    # button .aboutwin.frame.a.but -bitmap @$lib_path/images/$cbb(author_xbm) \
    #	    -relief ridge 
    label .aboutwin.frame.a.l1 -text "The wise man saves for the future ..."
    label .aboutwin.frame.a.l2 -text "... the fool spends everything he gets."
    label .aboutwin.frame.a.l3 -text "Proverbs 21:20"
    label .aboutwin.frame.a.l4 -text "``$name'' -- a Check Book Balancer for \
	    X, $cbb(version)"
    label .aboutwin.frame.a.l5 -text "Copyright (C) 1994 - 2000  \
	    Curtis L. Olson"
    label .aboutwin.frame.a.l6 -text "curt@sourceforge.net"
    label .aboutwin.frame.a.l7 -text "http://www.menet.umn.edu/~curt"
    button .aboutwin.frame.d.dismiss -text Dismiss \
	    -command "destroy .aboutwin" -font $cbb(button_font)

    pack .aboutwin.frame -side top -fill both -expand 1
    pack .aboutwin.frame.d -side bottom -fill x
    pack .aboutwin.frame.a -side top -fill both -expand 1
    pack .aboutwin.frame.a.but -padx 8 -pady 8 -side left -fill both -expand 1
    pack .aboutwin.frame.a.l1 .aboutwin.frame.a.l2 .aboutwin.frame.a.l3 \
	    .aboutwin.frame.a.l4 .aboutwin.frame.a.l5 \
	    .aboutwin.frame.a.l6 .aboutwin.frame.a.l7 \
    	    -ipadx 4m -side top -fill both -expand 1
    pack .aboutwin.frame.d.dismiss -side bottom -fill x -expand 1 \
	-padx 8 -pady 4
}


proc cbbWindow.helpwin {} {
    global cbb lib_path

    if {[winfo exists .helpwin] == 1} {
	wm withdraw .helpwin
        wm deiconify .helpwin
	return                
    }

    option add *font $cbb(msg_text_font)
    
    toplevel .helpwin

    wm title .helpwin "Help (Text)"
    wm iconname .helpwin "Help"
    frame .helpwin.frame -borderwidth 2 -relief raised
    frame .helpwin.frame.l -borderwidth 2
    frame .helpwin.frame.d -borderwidth 2
    pack .helpwin.frame -side top -fill both -expand 1
    pack .helpwin.frame.d -side bottom -fill x
    pack .helpwin.frame.l -side top -fill both -expand 1

    text .helpwin.frame.l.list -width 80 -height 40 -relief sunken \
	        -font $cbb(fixed_font) \
		-yscrollcommand ".helpwin.frame.l.scroll set"
	
    scrollbar .helpwin.frame.l.scroll -command ".helpwin.frame.l.list yview" \
	-relief flat
    pack .helpwin.frame.l.scroll -side right -fill y -expand 0
    pack .helpwin.frame.l.list -side left -fill both -expand 1

    bind .helpwin <KeyPress-Down> { .helpwin.frame.l.list \
	    yview scroll 1 units }
    bind .helpwin <Control-KeyPress-n> { .helpwin.frame.l.list \
	    yview scroll 1 units }
    bind .helpwin <KeyPress-n> { .helpwin.frame.l.list \
	    yview scroll 1 units }
    bind .helpwin <KeyPress-j> { .helpwin.frame.l.list \
	    yview scroll 1 units }

    bind .helpwin <KeyPress-Up> { .helpwin.frame.l.list \
	    yview scroll -1 units }
    bind .helpwin <Control-KeyPress-p> { .helpwin.frame.l.list \
	    yview scroll -1 units }
    bind .helpwin <KeyPress-p> { .helpwin.frame.l.list \
	    yview scroll -1 units }
    bind .helpwin <KeyPress-k> { .helpwin.frame.l.list \
	    yview scroll -1 units }

    bind .helpwin <KeyPress-Next> { .helpwin.frame.l.list \
	    yview scroll 1 pages }
    bind .helpwin <Control-KeyPress-v> { .helpwin.frame.l.list \
	    yview scroll 1 pages }

    bind .helpwin <KeyPress-Prior> { .helpwin.frame.l.list \
	    yview scroll -1 pages }
    bind .helpwin <Alt-KeyPress-v> { .helpwin.frame.l.list \
	    yview scroll -1 pages }

    button .helpwin.frame.d.dismiss -text "Dismiss" \
	    -font $cbb(button_font) -command { destroy .helpwin }
    pack .helpwin.frame.d.dismiss -side top -expand 1 -fill x \
	-padx 8 -pady 4
    set f [open $lib_path/docs/$cbb(help_text) r]

    while { [gets $f line] >= 0 } {
	.helpwin.frame.l.list insert end "$line\n"
    }

    .helpwin.frame.l.list configure -state disabled
}
