#!/usr/bin/perl
#  reports.pl - code for various reports
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: reports.pl,v 1.1.1.1 1999/12/18 02:05:27 curt Exp $


package CBB;

use strict;    # don't take no guff


my($cbb_incl_dir);


# specify the installed location of the necessary pieces.

BEGIN {
$CBB::cbb_incl_dir = "/usr/local/lib/cbb";
  unshift(@INC, $CBB::cbb_incl_dir);
}

require "common.pl";


# process arguments
sub process_rep_args {
    my($fromdate, $todate) = ("all", "all");
    my($arg, $nicefrom, $niceto, $month, $day, $year, $cur_year, $date_fmt);
    my($i, @account_list);

    $cur_year = substr(&raw_date, 0, 4);

    $i = 0;

    while ( $#ARGV >= 0 ) {
        $arg = shift(@ARGV);
        if ( substr($arg, 0 , 1) eq "-" ) {
	    if ( $arg eq "-date" ) {
		$date_fmt = shift(@ARGV);
	    } elsif ( $arg eq "-from" ) {
                $nicefrom = shift(@ARGV);

		if ( $date_fmt == 1) {
		    ($month, $day, $year) = split(/\//, $nicefrom);
		} else {
		    ($day, $month, $year) = split(/\./, $nicefrom);
		}
                $month = &pad($month);
                $day = &pad($day);
		if ( defined($year) ) {
                    $year = &pad($year);
		} else {
		    $year = $cur_year;
		}
                if ( length($year) == 2 ) {
                    $year = &century() . "$year";
                }
                $fromdate = "$year" . "$month" . "$day";

                # print "from $fromdate\n";
            } elsif ( $arg eq "-to" ) {
                $niceto = shift(@ARGV);

		if ( $date_fmt == 1) {
		    ($month, $day, $year) = split(/\//, $niceto);
		} else {
		    ($day, $month, $year) = split(/\./, $niceto);
		}
                $month = &pad($month);
                $day = &pad($day);
		if ( defined($year) ) {
                    $year = &pad($year);
		} else {
		    $year = $cur_year;
		}
                $year = &pad($year);
                if ( length($year) == 2 ) {
                    $year = &century() . "$year";
                }
                $todate = "$year" . "$month" . "$day";

                # print "to $todate\n";
            } elsif ( $arg eq "-to" ) {
                $niceto = shift(@ARGV);
                # print "to $todate\n";
            }
        } else {
	    $account_list[$i++] = $arg;
        }
    }

    return($date_fmt, $fromdate, $todate, @account_list);
}


1;
