;;; Chordpro generic mode
;; Chordpro is a format of songs with guitar chords.
;;
;; Instalation:   1) copy this file to emacs load path
;;                2) add to your .emacs (load "chordpro-mode.el")
;;
;; This mode is automatically set on files with suffix .pro.
;; You can change this, of course.


(defun chordpro-mode-choir-around ()
   (interactive)
   "Surround region with start and end of choir marks..."
   (vim-filter "echo \"{soc}\";cat;echo \"{eoc}\""))

(defun call-key (key)
   "Call the command KEY is bound to. Example of usage in lisp: (call-key [f2])."
   (interactive)
   (command-execute (key-binding key) t))


(define-generic-mode 'chordpro-generic-mode
   nil
   nil 
   '(("\\(\\[[^]]*\\]\\)"       1 'font-lock-string-face)
       ("^\\(#.*\\)"            1 'font-lock-comment-face)
       ("\\({subtitle[^}]*}\\)"         1 'font-lock-type-face)
       ("\\({title[^}]*}\\)"         1 'font-lock-keyword-face)
       ("\\({[^}]*}\\)"         1 'font-lock-variable-name-face)
       )    
   (list "\\.pro\\'" "httpd\\.conf\\'" "access\\.conf\\'")
   nil 
   "Generic mode for Chordpro guitar chord files.")
