%% Example in 
%% Kasper, A Unification Method for Disjunctive Feature Descriptions,
%%  25th ACL, 1987.
%% Disjunctive feature unification between 
%%   [rank:clause,subj:case:nom]^
%%   {[voice:passive,transitivity:trans,<subj>=<goal>] or 
%%	[voice:active,<subj>=<actor>]} ^
%%   {[transitivity:intrans,actor:person:3] or
%%	[trnsitivity:trans,goal:person:3]} ^
%%   {[number:sing,subj:number:sing] or [number:pl, subj:number:pl]}
%% and 
%%   [subj:[lex:y'all,person:2,number:pl]]
%% -->
%%  [rank:clause,subj:[case:nom,lex:y'all,person:2,number:pl],
%%   number:pl,voice:active,<subj>=<actor>,transitivity:trans,goal:person,3]
%%

cc1({voice/passive,trans/trans,subj/X,goal/X}).
cc1({voice/active, subj/X,actor/X}).
cc2({trans/intrans, actor/{person/third}}).
cc2({trans/trans, goal/{person/third}}).
cc3({numb/sing, subj/{numb/sing}}).
cc3({numb/pl, subj/{numb/pl}}).

%%  %p >	%% spy constraint transformation
%%  %s		%% step trace on
@ U={rank/clause, subj/{case/nom}},cc1(U),cc2(U),cc3(U),
	U={subj/{lex/yall,person/second,numb/pl}}.

%% --> c0(...)
%% then solve :-c0(U,_,_).  U is the solution.
%%  ----------------------------------------------
%% solution = c0(U_0, {subj/{person/second, numb/pl, lex/yall}},
%% 	{subj/{case/nom}, rank/clause})
%% c0(_p1, {subj/{person/second, numb/pl, lex/yall}}, {subj/{case/nom},
%% rank/clause}) :- cc2(_p1), cc1(_p1), fail;_p1={subj/{numb/sing},
%% numb/sing}.
%% c0(_p1, _p1, _p1) :- cc2(_p1), cc1(_p1);_p1={subj/{person/second,
%% numb/pl, case/nom, lex/yall}, numb/pl, rank/clause}.
%% 
%% CPU time = 0.000 sec (Constraints Handling = 0.000 sec)
%% 
%% _:-c0(U,_,_).
%%   U = {voice/active, trans/trans, subj/{person/second, numb/pl,
%% case/nom, lex/yall}, goal/{person/third}, actor/{person/second,
%% numb/pl, case/nom, lex/yall}, numb/pl, rank/clause};
%% 
%% CPU time = 0.017 sec (Constraints Handling = 0.000 sec)
%% _
