/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: dot.hpp,v 1.4 2001/08/09 16:53:46 cxsc Exp $ */

#ifndef dot_hpp_included
#define dot_hpp_included

#include <iostream>
#include <string> 

#include "compiler.h"
#include "RtsTyp.h"

namespace cxsc {


// ---- RTS - Definitionen ----
    

  // Form des dotprec. Akkus:
  //      Pointer auf a_btyp
  //  ist Pointer auf long
typedef  d_otpr   Dotprecision;

// ----------------------------
} // namespace cxsc 

#include "real.hpp"
#include "ioflags.hpp"

namespace cxsc {

class dotprecision;
class idotprecision;


//----------------------------------------------------------------------
// global verfgbare Dotprecision Variablen
//
//  dotakku[0..3] stehen fuer Matrix, Langzahl u.a. Pakete zur
//                Verfuegung
//  dotakku[4]    wird in den skalaren Paketen intern verwendet

#define MAXDOTAKKU      5
extern dotprecision dotakku[MAXDOTAKKU];

class dotprecision
{
   private:
      // ---- Dataelements  -----------------------------------------
      Dotprecision akku;

   public:
      // ---- Constructors  -----------------------------------------
      dotprecision(void)                 throw();
      dotprecision(const dotprecision &) throw();
      

      dotprecision & operator =(const dotprecision &) throw();
      dotprecision & operator =(const real &)         throw();
      dotprecision & operator =(const l_real &)       throw(); // in l_real.cpp

      // ---- Typecasts     -----------------------------------------
      explicit dotprecision(const real &)         throw();
      explicit dotprecision(const l_real &) throw();      
      friend inline dotprecision _dotprecision(const real &d) throw() { return dotprecision(d); }

      // ---- Destruktor    -----------------------------------------
      ~dotprecision(void) ;

      // ---- Input/Output  -----------------------------------------
      friend std::string  & operator <<(std::string &,const dotprecision &) throw();
      friend std::string  & operator >>(std::string &,dotprecision &)       throw();
      friend void           operator >>(const std::string &,dotprecision &) throw();
      friend void           operator >>(const char *,dotprecision &)        throw();
      friend std::ostream & operator <<(std::ostream &,const dotprecision &) throw();
      friend std::istream & operator >>(std::istream &,dotprecision &)      throw();

      // ---- Std.Operators -----------------------------------------
      friend  dotprecision operator -(const dotprecision &) throw();
      friend  dotprecision operator +(const dotprecision &) throw();

      friend  dotprecision operator +(const dotprecision &,const dotprecision &) throw();
      friend  dotprecision operator -(const dotprecision &,const dotprecision &) throw();
      friend inline idotprecision operator |(const dotprecision &,const dotprecision &) throw();

      friend  dotprecision operator +(const dotprecision &,const real &) throw();
      friend  dotprecision operator +(const real &,const dotprecision &) throw();
      friend  dotprecision operator -(const dotprecision &,const real &) throw();
      friend  dotprecision operator -(const real &,const dotprecision &) throw();
      friend inline idotprecision operator |(const real &,const dotprecision &) throw();
      friend inline idotprecision operator |(const dotprecision &,const real &) throw();

      friend dotprecision & operator +=(dotprecision &,const dotprecision &) throw();
      friend dotprecision & operator -=(dotprecision &,const dotprecision &) throw();

      friend dotprecision & operator +=(dotprecision &,const real &) throw();      
      friend dotprecision & operator -=(dotprecision &,const real &) throw();

      // ---- Comp.Operat. ------------------------------------------
      friend bool operator  !(const dotprecision &) throw();
//      operator void *() const throw() { if(sign(*this)) return (void *)1; else return 0;}

      friend bool operator ==(const dotprecision &,const dotprecision &) throw();
      friend bool operator !=(const dotprecision &,const dotprecision &) throw();
      friend bool operator  <(const dotprecision &,const dotprecision &) throw();
      friend bool operator  >(const dotprecision &,const dotprecision &) throw();
      friend bool operator <=(const dotprecision &,const dotprecision &) throw();
      friend bool operator >=(const dotprecision &,const dotprecision &) throw();

      friend bool operator ==(const real &,const dotprecision &) throw();
      friend bool operator !=(const real &,const dotprecision &) throw();
      friend bool operator  <(const real &,const dotprecision &) throw();
      friend bool operator  >(const real &,const dotprecision &) throw();
      friend bool operator <=(const real &,const dotprecision &) throw();
      friend bool operator >=(const real &,const dotprecision &) throw();

      friend bool operator ==(const dotprecision &,const real &) throw();
      friend bool operator !=(const dotprecision &,const real &) throw();
      friend bool operator  <(const dotprecision &,const real &) throw();
      friend bool operator  >(const dotprecision &,const real &) throw();
      friend bool operator <=(const dotprecision &,const real &) throw();
      friend bool operator >=(const dotprecision &,const real &) throw();

      // ---- Others ------------------------------------------------
      friend void rnd (const dotprecision&, real&, rndtype = RND_NEXT) throw();
      friend void rnd (const dotprecision&, real&, real&)              throw();
      friend real rnd (const dotprecision&, rndtype = RND_NEXT)        throw();

      friend dotprecision abs(const dotprecision &) throw();
      friend int         sign(const dotprecision &) throw();
      
      friend dotprecision & accumulate (dotprecision&, const real&, const real&) throw();

      // ---- internal functions ------------------------------------
      inline Dotprecision* ptr() { return &akku; }
   private:
      dotprecision & negdot(void) throw(); // Negates current dotprecision
};

} // namespace cxsc 

#endif

