/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: l_imath.hpp,v 1.3 2001/08/09 11:37:56 cxsc Exp $ */

#ifndef L_IMATH_HPP_INCLUDED
#define L_IMATH_HPP_INCLUDED

#include "l_interv.hpp"

namespace cxsc {

l_interval pow(const l_interval&, const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF); // Pow(x,y)
l_interval power(const l_interval&, int);       // Power(x,n)
l_interval sqr(const l_interval&);              // Sqr(x)

l_interval sqrt(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);             // Sqrt(x)
l_interval sqrt(const l_interval&, int) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);        // NSqrt(n,x)

l_interval sin(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW);    // Sin(x)
l_interval cos(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW);    // Cos(x)
l_interval tan(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW,ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);    // Tan(x)
l_interval cot(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW,ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);    // Cot(x)

l_interval asin(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);   // ASin(x)
l_interval acos(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);   // ACos(x)
l_interval atan(const l_interval&) throw();   // ATan(x)
l_interval acot(const l_interval&) throw();   // ACot(x)

l_interval exp(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW);    // Exp(x)
l_interval ln(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF);     // Ln(x)
l_interval sinh(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW);   // Sinh(x)
l_interval cosh(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW);   // Cosh(x)
l_interval tanh(const l_interval&) throw(ERROR_LINTERVAL_FAK_OVERFLOW);   // Tanh(x)
l_interval coth(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF,ERROR_LINTERVAL_FAK_OVERFLOW);   // Coth(x)           
 
l_interval asinh(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF,ERROR_LINTERVAL_FAK_OVERFLOW);  // ASinh(x)
l_interval acosh(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF,ERROR_LINTERVAL_FAK_OVERFLOW);  // ACosh(x)
l_interval atanh(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF,ERROR_LINTERVAL_FAK_OVERFLOW);  // ATanh(x)
l_interval acoth(const l_interval&) throw(ERROR_LINTERVAL_STD_FKT_OUT_OF_DEF,ERROR_LINTERVAL_FAK_OVERFLOW);  // ACoth(x)

} // namespace cxsc 

#endif

