/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: cimatrix.hpp,v 1.5 2001/08/09 12:52:37 cxsc Exp $ */

#ifndef _CXSC_CIMATRIX_HPP_INCLUDED
#define _CXSC_CIMATRIX_HPP_INCLUDED

#include "xscclass.hpp"
#include "cidot.hpp"
#include "civector.hpp"
#include "except.hpp"
#include "matrix.hpp"
#include "imatrix.hpp"
#include "cmatrix.hpp"


namespace cxsc {


class cimatrix;
class cimatrix_slice;

class cimatrix_subv
{
	friend class civector;
	friend class cimatrix;
	friend class cimatrix_slice;
	private:
	cinterval *dat;
	int lb,ub;
	int size,start,offset; // start=first element index 0..n-1
	
	public:
	friend INLINE cimatrix_subv Row(cimatrix &m,const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	friend INLINE cimatrix_subv Col(cimatrix &m,const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
//#if(IndCheck)
#ifdef _CXSC_FRIEND_TPL
	//----------------- Templates ---------------------------------------
template <class MV1,class MV2> friend  MV1 &_mvmvassign(MV1 &v,const MV2 &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV1>);
#else
	throw();
#endif
template <class MV,class S> friend  MV &_mvsassign(MV &v,const  S &r) throw();
template <class MV,class V> friend  MV &_mvvassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV2,class S> friend  V &_vmvassign(V &v,const MV2 &rv) throw();
template <class MV,class V> friend  MV &_mvvsetinf(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsetsup(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvusetinf(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvusetsup(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsetre(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsetim(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  V _mvabs(const MV &mv) throw();
template <class MV,class V> friend  V _mvim(const MV &mv) throw();
template <class MV,class V> friend  V _mvre(const MV &mv) throw();
template <class MV,class V> friend  V _mvdiam(const MV &mv) throw();
template <class MV,class V> friend  V _mvmid(const MV &mv) throw();
template <class MV,class V> friend  V _mvinf(const MV &mv) throw();
template <class MV,class V> friend  V _mvsup(const MV &mv) throw();

 template <class MV,class S> friend 	 MV &_mvssetinf(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvssetsup(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvsusetinf(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvsusetsup(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvssetim(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvssetre(MV &mv, const S &s) throw();
template <class DP,class V,class SV> friend 	 void _vmvaccu(DP &dp, const V & rv1, const SV &rv2)
#if(IndCheck)
		throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
template <class DP,class MV1,class MV2> friend 	 void _mvmvaccu(DP &dp, const MV1 & rv1, const MV2 &rv2)
#if(IndCheck)
		throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
 template <class MV1,class MV2,class S> friend 	 S _mvmvcimult(const MV1 & rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MV1>);
#else
	throw();
#endif
 template <class V,class MV,class S> friend 	 S _vmvcimult(const V &rv1, const MV &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
 template <class MV,class S,class E> friend 	 E _mvsmult(const MV &rv, const S &s) throw();
 template <class MV1,class MV2,class E> friend 	 E _mvmvplus(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV1,class MV2,class E> friend 	 E _mvmvminus(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvplus(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvminus(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class V,class MV,class E> friend 	 E _vmvminus(const V &rv1, const MV &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class S,class E> friend 	 E _mvsdiv(const MV &rv, const S &s) throw();
template <class MV,class S> friend  MV &_mvsmultassign(MV &v,const S &r) throw();
template <class MV, class S> friend  MV &_mvsplusassign(MV &v,const S &r) throw();
template <class MV,class S> friend  MV &_mvsminusassign(MV &v,const S &r) throw();
template <class MV,class S> friend  MV &_mvsdivassign(MV &v,const S &r) throw();
template <class MV,class V> friend  MV &_mvvplusassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV> friend  V &_vmvplusassign(V &rv,const MV &v)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<V>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvminusassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV> friend  V &_vmvminusassign(V &rv,const MV &v)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<V>);
#else
	throw();
#endif
 template <class MV1,class MV2,class E> friend 	 E _mvmvconv(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvconv(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvconvassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
 template <class MV1,class MV2,class E> friend 	 E _mvmvsect(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvsect(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsectassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV> friend  V &_vmvsectassign(V &rv,const MV &v)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<V>);
#else
	throw();
#endif

	// Real

	// complex

	// interval

#endif

	//----------------- Konstruktoren ----------------------------------

	explicit INLINE cimatrix_subv (cinterval *d, const int &l, const int &u, const int &s, const int &st, const int &o) throw():dat(d),lb(l),ub(u),size(s),start(st),offset(o) { }
	protected:
	INLINE cimatrix_subv(const cimatrix_subv &v) throw():dat(v.dat),lb(v.lb),ub(v.ub),size(v.size),start(v.start),offset(v.offset) { }
	public:

	//---------------------- Standardfunktionen ------------------------

	cimatrix_subv &operator =(const cimatrix_subv &rv) throw();
	cimatrix_subv &operator =(const cinterval &r) throw();
	cimatrix_subv &operator =(const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	cimatrix_subv &operator =(const cimatrix_slice &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const civector &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const civector_slice &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// Real
	INLINE cimatrix_subv &operator =(const real &r) throw();
	INLINE cimatrix_subv &operator =(const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const rmatrix_slice &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const rvector &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const rvector_slice &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const rmatrix_subv &rv) throw();

	// complex
	INLINE cimatrix_subv &operator =(const complex &r) throw();
	INLINE cimatrix_subv &operator =(const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const cmatrix_slice &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const cvector &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const cvector_slice &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const cmatrix_subv &rv) throw();

	// interval
	INLINE cimatrix_subv &operator =(const interval &r) throw();
	INLINE cimatrix_subv &operator =(const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const imatrix_slice &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const ivector &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const ivector_slice &v)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator =(const imatrix_subv &rv) throw();

	friend INLINE int Lb(const cimatrix_subv &rv) throw() { return rv.lb; }
	friend INLINE int Ub(const cimatrix_subv &rv) throw() { return rv.ub; }
	INLINE cinterval &operator [](const int &i) const
#if(IndCheck)
	throw(ERROR_CIVECTOR_ELEMENT_NOT_IN_VEC);
#else
	throw();
#endif
	INLINE cimatrix_subv &operator ()() throw() { return *this; }
	INLINE cimatrix_subv operator ()(const int &i)
#if(IndCheck)
	throw(ERROR_CIVECTOR_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE cimatrix_subv operator ()(const int &i1,const int &i2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	
	INLINE cimatrix_subv &cimatrix_subv::operator *=(const cinterval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const cinterval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const cinterval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator /=(const cinterval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const civector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const civector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const civector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const civector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const civector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const civector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const civector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const civector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// real
	INLINE cimatrix_subv &cimatrix_subv::operator *=(const real &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const real &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const real &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator /=(const real &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// complex
	INLINE cimatrix_subv &cimatrix_subv::operator *=(const complex &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const complex &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const complex &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator /=(const complex &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const cvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const cvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const cvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const cvector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// interval
	INLINE cimatrix_subv &cimatrix_subv::operator *=(const interval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const interval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const interval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator /=(const interval &c) throw();
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator -=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator +=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator |=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &cimatrix_subv::operator &=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
//#else
//#endif	

};


//----------------------- Matrix -----------------------------------------------

class cimatrix_slice;

class cimatrix
{
	friend class cimatrix_slice;
	friend class cimatrix_subv;
	private:
	cinterval *dat;
	int lb1,ub1,lb2,ub2,xsize,ysize;

	public:
//#if(IndCheck)
#ifdef _CXSC_FRIEND_TPL
	//----------------- Templates ---------------------------------------
template <class S,class M> friend  void _smconstr(S &s,const M &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<M>,ERROR__USE_OF_UNINITIALIZED_OBJ<M>);
#else
	throw();
#endif
template <class V,class M,class S> friend  void _vmconstr(V &v,const M &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<M>);
#else
	throw();
#endif
 template <class M1,class M2,class S> friend 	 M1 &_mmassign(M1 &m1,const M2 &m,S ms) throw();
 template <class M,class MS2,class S> friend 	 M &_mmsassign(M &m,const MS2 &ms) throw();
 template <class MS,class M> friend 	 MS &_msmassign(MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class M,class S> friend 	 M &_msassign(M &m,const S &r) throw();
template <class V,class M,class S> friend  V &_vmassign(V &v,const M &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<M>);
#else
	throw();
#endif
template <class M,class V,class S> friend  M &_mvassign(M &m,const V &v) throw();
 template <class M> friend 	 int _mlb(const M &m, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 int _mub(const M &m, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 M &_msetlb(M &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 M &_msetub(M &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 void _mresize(M &A) throw();
 template <class M,class S> friend 	 void _mresize(M &A,const int &m, const int &n)
#if(IndCheck)
		throw(ERROR__WRONG_BOUNDARIES<M>);
#else
	throw();
#endif
 template <class M,class S> friend 	 void _mresize(M &A,const int &m1, const int &m2,const int &n1,const int &n2)
#if(IndCheck)
		throw(ERROR__WRONG_BOUNDARIES<M>);
#else
	throw();
#endif
 template <class M,class E> friend 	 E _mabs(const M &m) throw();
 template <class M,class E> friend 	 E _mdiam(const M &m) throw();
 template <class M,class E> friend 	 E _mmid(const M &m) throw();
 template <class M,class E> friend 	 E _mre(const M &m) throw();
 template <class M,class E> friend 	 E _mim(const M &m) throw();
	friend INLINE rmatrix SupRe(const cimatrix &v) throw();
	friend INLINE rmatrix SupIm(const cimatrix &v) throw();
	friend INLINE rmatrix InfRe(const cimatrix &v) throw();
	friend INLINE rmatrix InfIm(const cimatrix &v) throw();
 template <class M1,class M2> friend 	 M1 &_mmsetre(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmsetim(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetre(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetim(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class E> friend 	 E _minf(const M &m) throw();
 template <class M,class E> friend 	 E _msup(const M &m) throw();
 template <class M1,class M2> friend 	 M1 &_mmsetinf(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmsetsup(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetinf(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetsup(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmusetinf(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmusetsup(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmsusetinf(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmsusetsup(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
	//-------------- matrix-matrix -------------
 template <class M1,class M2,class E> friend 	 E _mmplus(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsplus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M> friend 	 M _mminus(const M &m) throw();
 template <class MS,class E> friend 	 E _msminus(const MS &ms) throw();
 template <class M1,class M2,class E> friend 	 E _mmminus(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmplusassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsplusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmplusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsplus(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsminus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmminus(const MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsminus(const MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmminusassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsminusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmminusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class M1,class M2,class E> friend 	 E _mmcimult(const M1 &m1, const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2,class S> friend 	 M1 &_mmcimultassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmscimult(const M &m1, const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmcimult(const MS &ms, const M &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class S> friend 	 M &_mmscimultassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmscimult(const MS1 &ms1, const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2,class E> friend 	 E _mmconv(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsconv(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmconvassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsconvassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmconvassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsconv(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2,class E> friend 	 E _mmsect(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmssect(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmsectassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmssectassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmsectassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmssect(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
	//-------- matrix-scalar -----------------
 template <class S,class M,class E> friend 	 E _smmult(const S &c, const M &m) throw();
 template <class M,class S> friend 	 M &_msmultassign(M &m,const S &c) throw();
 template <class S,class MS,class E> friend 	 E _smsmult(const S &c, const MS &ms) throw();
 template <class M,class S,class E> friend 	 E _msdiv(const M &m,const S &c) throw();
 template <class M,class S> friend 	 M &_msdivassign(M &m,const S &c) throw();
 template <class MS,class S,class E> friend 	 E _mssdiv(const MS &ms, const S &c) throw();
	//-------- matrix-vector ---------------------
 template <class M,class V,class E> friend 	 E _mvcimult(const M &m,const V &v)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class V,class M,class E> friend 	 E _vmcimult(const V &v,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class V,class M,class S> friend 	 V &_vmcimultassign(V &v,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class VS,class M,class S> friend 	 VS &_vsmcimultassign(VS &v,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
	
 template <class M> friend 	 void *_mvoid(const M &m) throw();
 template <class M> friend 	 bool _mnot(const M &m) throw();
 template <class MS> friend 	 void *_msvoid(const MS &ms) throw();
 template <class MS> friend 	 bool _msnot(const MS &ms) throw();
 template <class M1,class M2> friend 	 bool _mmeq(const M1 &m1,const M2 &m2) throw();
 template <class M1,class M2> friend 	 bool _mmneq(const M1 &m1,const M2 &m2) throw();
 template <class M1,class M2> friend 	 bool _mmless(const M1 &m1,const M2 &m2) throw();
 template <class M1,class M2> friend 	 bool _mmleq(const M1 &m1,const M2 &m2) throw();
 template <class M,class MS> friend 	 bool _mmseq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsneq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsless(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsleq(const M &m1,const MS &ms) throw();
 template <class MS,class M> friend 	 bool _msmless(const MS &ms,const M &m1) throw();
 template <class MS,class M> friend 	 bool _msmleq(const MS &ms,const M &m1) throw();
 template <class M> friend 	std::ostream &_mout(std::ostream &s,const M &r) throw();
 template <class M> friend 	std::istream &_min(std::istream &s,M &r) throw();

	// Real

	//--- Real --------- matrix-matrix ----------------------

	//--- Real --------- matrix-scalar ----------------------

	//--- Real --------- matrix-vector ----------------------
 template <class MS,class V,class E> friend 	 E _msvcimult(const MS &ms,const V &v)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class V,class MS,class E> friend 	 E _vmscimult(const V &v,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif

	// interval

	//--- interval --------- matrix-matrix ----------------------

	//--- interval --------- matrix-scalar ----------------------


	//--- interval --------- matrix-vector ----------------------

	// complex

	//--- complex --------- matrix-matrix ----------------------

	//--- complex --------- matrix-scalar ----------------------

	//--- complex --------- matrix-vector ----------------------

	// --- complex x real ----------------
	// -- complex x interval ----------------------
	// ---- complex x interval --- scalar--------


	// ---- complex x interval --- vector --------
	// ---- complex x interval --- matrix ------------

	// complex x complex --------------------


#endif
	
	//--------------------------  Konstruktoren ----------------------------

// cinterval
	INLINE cimatrix(const cimatrix &rm) throw();
	INLINE cimatrix(const cimatrix_slice &rm) throw();
	INLINE cimatrix() throw();
	explicit INLINE cimatrix(const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif
	explicit INLINE cimatrix(const int &m1, const int &n1, const int &m2, const int &n2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif
	explicit INLINE cimatrix(const civector &v) throw();
	explicit INLINE cimatrix(const civector_slice &v) throw();
	explicit INLINE cimatrix(const cinterval &r) throw();
	INLINE cimatrix &operator =(const cinterval &r) throw();
	INLINE cimatrix &operator =(const cimatrix &m) throw();
	INLINE cimatrix &operator =(const cimatrix_slice &ms) throw();
	INLINE cimatrix &operator =(const civector &v) throw();
	INLINE cimatrix &operator =(const civector_slice &v) throw();
//  real
	explicit INLINE cimatrix(const real &r) throw();
	explicit INLINE cimatrix(const rmatrix &rm) throw();
	explicit INLINE cimatrix(const rmatrix_slice &rm) throw();
	explicit INLINE cimatrix(const rvector &v) throw();
	explicit INLINE cimatrix(const rvector_slice &v) throw();
	INLINE cimatrix &operator =(const real &r) throw();
	INLINE cimatrix &operator =(const rmatrix &m) throw();
	INLINE cimatrix &operator =(const rmatrix_slice &ms) throw();
	INLINE cimatrix &operator =(const rvector &v) throw();
	INLINE cimatrix &operator =(const rvector_slice &v) throw();

//  complex
	explicit INLINE cimatrix(const complex &r) throw();
	explicit INLINE cimatrix(const cmatrix &rm) throw();
	explicit INLINE cimatrix(const cmatrix_slice &rm) throw();
	explicit INLINE cimatrix(const cvector &v) throw();
	explicit INLINE cimatrix(const cvector_slice &v) throw();
	INLINE cimatrix &operator =(const complex &r) throw();
	INLINE cimatrix &operator =(const cmatrix &m) throw();
	INLINE cimatrix &operator =(const cmatrix_slice &ms) throw();
	INLINE cimatrix &operator =(const cvector &v) throw();
	INLINE cimatrix &operator =(const cvector_slice &v) throw();

//  interval
	explicit INLINE cimatrix(const interval &r) throw();
	explicit INLINE cimatrix(const imatrix &rm) throw();
	explicit INLINE cimatrix(const imatrix_slice &rm) throw();
	explicit INLINE cimatrix(const ivector &v) throw();
	explicit INLINE cimatrix(const ivector_slice &v) throw();
	INLINE cimatrix &operator =(const interval &r) throw();
	INLINE cimatrix &operator =(const imatrix &m) throw();
	INLINE cimatrix &operator =(const imatrix_slice &ms) throw();
	INLINE cimatrix &operator =(const ivector &v) throw();
	INLINE cimatrix &operator =(const ivector_slice &v) throw();

	//--------------------------- Destruktoren -----------------------------

	INLINE ~cimatrix() throw() { delete [] dat; }

	//------------------------- Standardfunktionen -------------------------

	INLINE cimatrix_subv operator [](const int &i) const
#if(IndCheck)
	throw(ERROR_CIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE cimatrix_subv operator [](const cxscmatrix_column &i) const
#if(IndCheck)
	throw(ERROR_CIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE cimatrix &operator ()() throw() { return *this; }
	INLINE cimatrix_slice operator ()(const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_CIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE cimatrix_slice operator ()(const int &m1, const int &m2, const int &n1, const int &n2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE operator void*() throw();
//#else
//#endif
};

	
class cimatrix_slice
{
	friend class cimatrix;
	private:
	cinterval *dat;
	int offset1,offset2,mxsize,mysize;
	int start1,end1,start2,end2,sxsize,sysize;     // slice size

	public:
//#if(IndCheck)
#ifdef _CXSC_FRIEND_TPL
	//----------------- Templates ---------------------------------------
template <class V,class MS,class S> friend  void _vmsconstr(V &v,const MS &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<MS>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmassign(MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsassign(MS1 &ms1,const MS2 &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class M,class MS2,class S> friend 	 M &_mmsassign(M &m,const MS2 &ms) throw();
 template <class MS,class S> friend 	 MS &_mssassign(MS &ms,const S &r) throw();
 template <class MS> friend 	 int _mslb(const MS &ms, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<MS>);
#else
	throw();
#endif
 template <class MS> friend 	 int _msub(const MS &ms, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<MS>);
#else
	throw();
#endif
 template <class MS,class E> friend 	 E _msabs(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msinf(const MS &ms) throw();
 template <class MS,class E> friend 	 E _mssup(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msdiam(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msmid(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msre(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msim(const MS &ms) throw();
	friend INLINE rmatrix SupRe(const cimatrix_slice &v) throw();
	friend INLINE rmatrix SupIm(const cimatrix_slice &v) throw();
	friend INLINE rmatrix InfRe(const cimatrix_slice &v) throw();
	friend INLINE rmatrix InfIm(const cimatrix_slice &v) throw();
 template <class MS1,class M2> friend 	 MS1 &_msmsetre(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmsetim(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssetre(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssetim(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmsetinf(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmsetsup(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssetinf(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssetsup(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmusetinf(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmusetsup(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsusetinf(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsusetsup(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
	//-------- matrix-matrix --------------
 template <class MS,class E> friend 	 E _msminus(const MS &ms) throw();
 template <class M,class MS,class E> friend 	 E _mmsplus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsplus(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsplusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmplusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsplusassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsminus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmminus(const MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsminus(const MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsminusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmminusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsminusassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmscimult(const M &m1, const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmcimult(const MS &ms, const M &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class S> friend 	 M &_mmscimultassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmscimult(const MS1 &ms1, const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsconv(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsconvassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmconvassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsconvassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsconv(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmssect(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmssectassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmsectassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssectassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmssect(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
	//--------- matrix-vector --------------
 template <class MS,class V,class E> friend 	 E _msvcimult(const MS &ms,const V &v)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class V,class MS,class E> friend 	 E _vmscimult(const V &v,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class V,class MS,class S> friend 	 V &_vmscimultassign(V &v,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
	//--------- matrix-scalar --------------
 template <class S,class MS,class E> friend 	 E _smsmult(const S &c, const MS &ms) throw();
 template <class MS,class S> friend 	 MS &_mssmultassign(MS &ms,const S &c) throw();
 template <class MS,class S,class E> friend 	 E _mssdiv(const MS &ms, const S &c) throw();
 template <class MS,class S> friend 	 MS &_mssdivassign(MS &ms,const S &c) throw();
	
 template <class MS> friend 	 void *_msvoid(const MS &ms) throw();
 template <class MS> friend 	 bool _msnot(const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmseq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsneq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsless(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsleq(const M &m1,const MS &ms) throw();
 template <class MS,class M> friend 	 bool _msmless(const MS &ms,const M &m1) throw();
 template <class MS,class M> friend 	 bool _msmleq(const MS &ms,const M &m1) throw();
 template <class MS1,class MS2> friend 	 bool _msmseq(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS1,class MS2> friend 	 bool _msmsneq(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS1,class MS2> friend 	 bool _msmsless(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS1,class MS2> friend 	 bool _msmsleq(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS> friend 	std::ostream &_msout(std::ostream &s,const MS &r) throw();
 template <class MS> friend 	std::istream &_msin(std::istream &s,MS &r) throw();

	// Real

	//--- Real ------------ matrix-scalar -----------
	
	
	//--- Real ------------ matrix-vector -----------

	//--- Real ------------ matrix-matrix -----------

	// interval

	//--- interval ------------ matrix-scalar -----------
	
	
	//--- interval ------------ matrix-vector -----------

	//--- interval ------------ matrix-matrix -----------

	// complex

	//--- complex ------------ matrix-scalar -----------
	
	
	//--- complex ------------ matrix-vector -----------


	//--- complex ------------ matrix-matrix -----------


#endif

	//--------------- Konstruktoren ----------------------------------------

	explicit INLINE cimatrix_slice(cimatrix &a,const int &l1,const int &u1,const int &l2, const int &u2) throw():dat(a.dat),offset1(l1-a.lb1),offset2(l2-a.lb2),mxsize(a.xsize),mysize(a.ysize),start1(l1),end1(u1),start2(l2),end2(u2),sxsize(u2-l2+1),sysize(u1-l1+1) { }
	explicit INLINE cimatrix_slice(cimatrix_slice &a,const int &l1,const int &u1,const int &l2, const int &u2) throw():dat(a.dat),offset1(a.offset1+l1-a.start1),offset2(a.offset2+l2-a.start2),mxsize(a.mxsize),mysize(a.mysize),start1(l1),end1(u1),start2(l2),end2(u2),sxsize(u2-l2+1),sysize(u1-l1+1) { }
	protected: 
	INLINE cimatrix_slice(const cimatrix_slice &ms) throw():dat(ms.dat),offset1(ms.offset1),offset2(ms.offset2),mxsize(ms.mxsize),mysize(ms.mysize),start1(ms.start1),end1(ms.end1),start2(ms.start2),end2(ms.end2),sxsize(ms.sxsize),sysize(ms.sysize) { }
	public:

	//---------------- Standardfunktionen -----------------------------------

	friend INLINE civector::civector(const cimatrix_slice &sl)
#if(IndCheck)
	throw(ERROR_CIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	friend INLINE cimatrix::cimatrix(const cimatrix_slice &) throw();
	INLINE cimatrix_slice &operator =(const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const cinterval &r) throw();
	INLINE cimatrix_slice &operator =(const civector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const civector_slice &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const cimatrix_subv &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// real
	INLINE cimatrix_slice &operator =(const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const real &r) throw();
	INLINE cimatrix_slice &operator =(const rvector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const rvector_slice &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const rmatrix_subv &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	// interval
	INLINE cimatrix_slice &operator =(const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const interval &r) throw();
	INLINE cimatrix_slice &operator =(const ivector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const ivector_slice &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const imatrix_subv &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	// complex
	INLINE cimatrix_slice &operator =(const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const complex &r) throw();
	INLINE cimatrix_slice &operator =(const cvector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const cvector_slice &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator =(const cmatrix_subv &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE cimatrix_subv operator [](const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE cimatrix_subv operator [](const cxscmatrix_column &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator ()() throw() { return *this; }
	INLINE cimatrix_slice operator ()(const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_CIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE cimatrix_slice operator ()(const int &m1, const int &m2, const int &n1, const int &n2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE cimatrix_slice::operator void*() throw();

	INLINE cimatrix_slice &cimatrix_slice::operator +=(const cinterval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const cinterval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator *=(const cinterval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator /=(const cinterval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE cimatrix_slice &cimatrix_slice::operator +=(const real &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const real &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator *=(const real &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator /=(const real &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE cimatrix_slice &cimatrix_slice::operator +=(const complex &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const complex &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator *=(const complex &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator /=(const complex &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const cmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const cmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const cmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const cmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE cimatrix_slice &cimatrix_slice::operator +=(const interval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const interval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator *=(const interval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator /=(const interval &c) throw();
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator +=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator -=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator |=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &cimatrix_slice::operator &=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &operator *=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

//#else
//#endif
};

//================================================================
//====================== Subvector Functions =====================

//=======================Vector / Scalar =========================

	INLINE civector operator /(const cimatrix_subv &rv, const cinterval &s) throw();
	INLINE civector operator *(const cimatrix_subv &rv, const cinterval &s) throw();
	INLINE civector operator *(const cinterval &s, const cimatrix_subv &rv) throw();
	INLINE ivector abs(const cimatrix_subv &mv) throw();
	INLINE cvector diam(const cimatrix_subv &mv) throw();
	INLINE cvector mid(const cimatrix_subv &mv) throw();
	INLINE cvector Inf(const cimatrix_subv &mv) throw();
	INLINE cvector Sup(const cimatrix_subv &mv) throw();
	INLINE ivector Im(const cimatrix_subv &mv) throw();
	INLINE ivector Re(const cimatrix_subv &mv) throw();
	INLINE rmatrix SupRe(const cimatrix &v) throw();
	INLINE rmatrix SupIm(const cimatrix &v) throw();
	INLINE rmatrix InfRe(const cimatrix &v) throw();
	INLINE rmatrix InfIm(const cimatrix &v) throw();
	INLINE rmatrix SupRe(const cimatrix_slice &v) throw();
	INLINE rmatrix SupIm(const cimatrix_slice &v) throw();
	INLINE rmatrix InfRe(const cimatrix_slice &v) throw();
	INLINE rmatrix InfIm(const cimatrix_slice &v) throw();
	INLINE cimatrix_subv &SetInf(cimatrix_subv &iv,const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &SetSup(cimatrix_subv &iv,const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &UncheckedSetInf(cimatrix_subv &iv,const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &UncheckedSetSup(cimatrix_subv &iv,const cvector &rv)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &SetIm(cimatrix_subv &iv,const ivector &rv)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_subv &SetRe(cimatrix_subv &iv,const ivector &rv)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE cimatrix_subv &SetSup(cimatrix_subv &iv,const complex &r) throw();
	INLINE cimatrix_subv &SetInf(cimatrix_subv &iv,const complex &r) throw();
	INLINE cimatrix_subv &UncheckedSetSup(cimatrix_subv &iv,const complex &r) throw();
	INLINE cimatrix_subv &SetUncheckedInf(cimatrix_subv &iv,const complex &r) throw();
	INLINE cimatrix_subv &SetRe(cimatrix_subv &iv,const interval &r) throw();
	INLINE cimatrix_subv &SetIm(cimatrix_subv &iv,const interval &r) throw();

//======================== Vector / Vector ========================

	
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const civector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const civector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const civector_slice & sl1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const civector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cinterval operator *(const cimatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cinterval operator *(const civector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cinterval operator *(const cimatrix_subv &rv1,const civector &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cinterval operator *(const civector_slice &sl,const cimatrix_subv &sv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cinterval operator *(const cimatrix_subv &mv,const civector_slice &vs)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE civector operator +(const cimatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator +(const cimatrix_subv &rv1,const civector &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator +(const civector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator +(const civector_slice &sl,const cimatrix_subv &mv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator +(const cimatrix_subv &mv,const civector_slice &sl)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE civector operator -(const cimatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator -(const civector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator -(const cimatrix_subv &rv1,const civector &rv2)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator -(const civector_slice &sl,const cimatrix_subv &mv)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator -(const cimatrix_subv &mv,const civector_slice &sl)
#if(IndCheck)
	throw(ERROR_CIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

//  real

	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const rmatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const rvector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const rvector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const rvector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const rmatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const rvector_slice & sl1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
// complex

	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const cmatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const cvector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const cvector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cvector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cmatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cvector_slice & sl1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
// interval

	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const ivector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const cimatrix_subv & rv1, const ivector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const ivector & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const imatrix_subv & rv1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(cidotprecision &dp, const ivector_slice & sl1, const cimatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	

//====================================================================
//===================== Matrix Functions =============================

	INLINE cimatrix _imatrix(const cimatrix &rm) throw();
	INLINE cimatrix _imatrix(const civector &v) throw();
	INLINE cimatrix _imatrix(const civector_slice &v) throw();
	INLINE cimatrix _imatrix(const cinterval &r) throw();

	INLINE int Lb(const cimatrix &rm, const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE int Ub(const cimatrix &rm, const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE int Lb(const cimatrix_slice &rm, const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE int Ub(const cimatrix_slice &rm, const int &i)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE cimatrix &SetLb(cimatrix &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE cimatrix &SetUb(cimatrix &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE void Resize(cimatrix &A) throw();
	INLINE void Resize(cimatrix &A,const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif
	INLINE void Resize(cimatrix &A,const int &m1, const int &m2,const int &n1,const int &n2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif

	INLINE imatrix abs(const cimatrix &m) throw();
	INLINE imatrix abs(const cimatrix_slice &ms) throw();
	INLINE cmatrix diam(const cimatrix &m) throw();
	INLINE cmatrix diam(const cimatrix_slice &m) throw();
	INLINE cmatrix mid(const cimatrix &m) throw();
	INLINE cmatrix mid(const cimatrix_slice &m) throw();
	INLINE cmatrix Inf(const cimatrix &m) throw();
	INLINE cmatrix Sup(const cimatrix &m) throw();
	INLINE cmatrix Inf(const cimatrix_slice &m) throw();
	INLINE cmatrix Sup(const cimatrix_slice &m) throw();
	INLINE cimatrix &SetInf(cimatrix &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetInf(cimatrix_slice &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &SetInf(cimatrix &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetInf(cimatrix_slice &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &SetSup(cimatrix &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetSup(cimatrix_slice &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &SetSup(cimatrix &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetSup(cimatrix_slice &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &UncheckedSetInf(cimatrix &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &UncheckedSetInf(cimatrix_slice &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &UncheckedSetInf(cimatrix &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &UncheckedSetInf(cimatrix_slice &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &UncheckedSetSup(cimatrix &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &UncheckedSetSup(cimatrix_slice &cm,const cmatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &UncheckedSetSup(cimatrix &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &UncheckedSetSup(cimatrix_slice &cm,const cmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE imatrix Im(const cimatrix &m) throw();
	INLINE imatrix Re(const cimatrix &m) throw();
	INLINE imatrix Im(const cimatrix_slice &m) throw();
	INLINE imatrix Re(const cimatrix_slice &m) throw();
	INLINE cimatrix &SetIm(cimatrix &cm,const imatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetIm(cimatrix_slice &cm,const imatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &SetIm(cimatrix &cm,const imatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetIm(cimatrix_slice &cm,const imatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &SetRe(cimatrix &cm,const imatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetRe(cimatrix_slice &cm,const imatrix &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &SetRe(cimatrix &cm,const imatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix_slice &SetRe(cimatrix_slice &cm,const imatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

//===================== Matrix / Scalar ===============================

	INLINE cimatrix operator *(const cinterval &c, const cimatrix &m) throw();
	INLINE cimatrix operator *(const cinterval &c, const cimatrix_slice &ms) throw();
	INLINE cimatrix operator *(const cimatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator *(const cimatrix_slice &ms,const cinterval &c) throw();
	INLINE cimatrix &operator *=(cimatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator /(const cimatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator /(const cimatrix_slice &ms, const cinterval &c) throw();
	INLINE cimatrix &operator /=(cimatrix &m,const cinterval &c) throw();
	
//------------ real - cimatrix -----------------------------------------------

	INLINE cimatrix operator *(const real &c, const cimatrix &m) throw();
	INLINE cimatrix operator *(const real &c, const cimatrix_slice &ms) throw();
	INLINE cimatrix operator *(const cimatrix &m,const real &c) throw();
	INLINE cimatrix operator *(const cimatrix_slice &ms,const real &c) throw();
	INLINE cimatrix &operator *=(cimatrix &m,const real &c) throw();
	INLINE cimatrix operator /(const cimatrix &m,const real &c) throw();
	INLINE cimatrix operator /(const cimatrix_slice &ms, const real &c) throw();
	INLINE cimatrix &operator /=(cimatrix &m,const real &c) throw();
//----------------- rmatrix - cinterval ----------------

	INLINE cimatrix operator *(const cinterval &c, const rmatrix &m) throw();
	INLINE cimatrix operator *(const cinterval &c, const rmatrix_slice &ms) throw();
	INLINE cimatrix operator *(const rmatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator *(const rmatrix_slice &ms,const cinterval &c) throw();
	INLINE cimatrix operator /(const rmatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator /(const rmatrix_slice &ms, const cinterval &c) throw();
	
//------------ complex - cimatrix -----------------------------------------------

	INLINE cimatrix operator *(const complex &c, const cimatrix &m) throw();
	INLINE cimatrix operator *(const complex &c, const cimatrix_slice &ms) throw();
	INLINE cimatrix operator *(const cimatrix &m,const complex &c) throw();
	INLINE cimatrix operator *(const cimatrix_slice &ms,const complex &c) throw();
	INLINE cimatrix &operator *=(cimatrix &m,const complex &c) throw();
	INLINE cimatrix operator /(const cimatrix &m,const complex &c) throw();
	INLINE cimatrix operator /(const cimatrix_slice &ms, const complex &c) throw();
	INLINE cimatrix &operator /=(cimatrix &m,const complex &c) throw();
//----------------- cmatrix - cinterval ----------------

	INLINE cimatrix operator *(const cinterval &c, const cmatrix &m) throw();
	INLINE cimatrix operator *(const cinterval &c, const cmatrix_slice &ms) throw();
	INLINE cimatrix operator *(const cmatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator *(const cmatrix_slice &ms,const cinterval &c) throw();
	INLINE cimatrix operator /(const cmatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator /(const cmatrix_slice &ms, const cinterval &c) throw();
	
//------------ interval - cimatrix -----------------------------------------------

	INLINE cimatrix operator *(const interval &c, const cimatrix &m) throw();
	INLINE cimatrix operator *(const interval &c, const cimatrix_slice &ms) throw();
	INLINE cimatrix operator *(const cimatrix &m,const interval &c) throw();
	INLINE cimatrix operator *(const cimatrix_slice &ms,const interval &c) throw();
	INLINE cimatrix &operator *=(cimatrix &m,const interval &c) throw();
	INLINE cimatrix operator /(const cimatrix &m,const interval &c) throw();
	INLINE cimatrix operator /(const cimatrix_slice &ms, const interval &c) throw();
	INLINE cimatrix &operator /=(cimatrix &m,const interval &c) throw();
//----------------- imatrix - cinterval ----------------

	INLINE cimatrix operator *(const cinterval &c, const imatrix &m) throw();
	INLINE cimatrix operator *(const cinterval &c, const imatrix_slice &ms) throw();
	INLINE cimatrix operator *(const imatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator *(const imatrix_slice &ms,const cinterval &c) throw();
	INLINE cimatrix operator /(const imatrix &m,const cinterval &c) throw();
	INLINE cimatrix operator /(const imatrix_slice &ms, const cinterval &c) throw();
	

//============================ Matrix / Vector ===================================


	INLINE civector operator *(const cimatrix &m,const civector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const cimatrix_slice &ms,const civector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const civector &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const civector &v,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector &operator *=(civector &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector &operator *=(civector &v,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE civector operator *(const civector_slice &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const civector_slice &v,const cimatrix_slice &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//----------------- real -------------------------------------

	INLINE civector operator *(const rvector &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const rvector &v,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const rvector_slice &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE civector operator *(const cimatrix &m,const rvector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const cimatrix_slice &ms,const rvector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//----------------- complex -------------------------------------

	INLINE civector operator *(const cvector &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const cvector &v,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const cvector_slice &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE civector operator *(const cimatrix &m,const cvector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const cimatrix_slice &ms,const cvector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//----------------- interval -------------------------------------

	INLINE civector operator *(const ivector &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const ivector &v,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const ivector_slice &v,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE civector operator *(const cimatrix &m,const ivector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE civector operator *(const cimatrix_slice &ms,const ivector &v)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	

//================ Matrix / Matrix ============================

	INLINE const cimatrix &operator +(const cimatrix &m1) throw();
	INLINE cimatrix operator +(const cimatrix_slice &ms) throw();
	INLINE cimatrix operator +(const cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator -(const cimatrix &m) throw();
	INLINE cimatrix operator -(const cimatrix_slice &ms) throw();
	INLINE cimatrix operator -(const cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms1,const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator *(const cimatrix &m1, const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms, const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms1, const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	
	INLINE cimatrix operator |(const cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator &(const cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- rmatrix-cimatrix ------------------
	INLINE cimatrix operator +(const rmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const rmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const rmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const rmatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &m1,const rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator -(const rmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const rmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const rmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const rmatrix_slice &ms1,const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms1,const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator *(const rmatrix &m1, const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const rmatrix &m1, const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const rmatrix_slice &ms, const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms, const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const rmatrix_slice &ms1, const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms1, const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator |(const rmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const rmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const rmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const rmatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &m1,const rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator &(const rmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const rmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const rmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const rmatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &m1,const rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- cmatrix-cimatrix ------------------
	INLINE cimatrix operator +(const cmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cmatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &m1,const cmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator -(const cmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cmatrix_slice &ms1,const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms1,const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator *(const cmatrix &m1, const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cmatrix &m1, const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cmatrix_slice &ms, const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms, const cmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cmatrix_slice &ms1, const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms1, const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator |(const cmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &m1,const cmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator &(const cmatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cmatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cmatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cmatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &m1,const cmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- imatrix-cimatrix ------------------
	INLINE cimatrix operator +(const imatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cimatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator +=(cimatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator -(const imatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix_slice &ms1,const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cimatrix_slice &ms1,const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator -=(cimatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator *(const imatrix &m1, const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix &m1, const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix &m1, const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix_slice &ms, const cimatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms, const imatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix_slice &ms1, const cimatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cimatrix_slice &ms1, const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator *=(cimatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator |(const imatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cimatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator |=(cimatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator &(const imatrix &m1,const cimatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix &m,const cimatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix_slice &ms,const cimatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix_slice &m1,const cimatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cimatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix &operator &=(cimatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- cmatrix-imatrix ------------------
	INLINE cimatrix operator +(const cmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const cmatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator +(const imatrix_slice &m1,const cmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator -(const cmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const cmatrix_slice &ms1,const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator -(const imatrix_slice &ms1,const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator *(const cmatrix &m1, const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix &m1, const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cmatrix &m1, const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix &m1, const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cmatrix_slice &ms, const imatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix_slice &ms, const cmatrix &m1)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const cmatrix_slice &ms1, const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator *(const imatrix_slice &ms1, const cmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator |(const cmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator |(const imatrix_slice &m1,const cmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE cimatrix operator &(const cmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix &m1,const cmatrix &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix &m,const cmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix_slice &ms,const cmatrix &m)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const cmatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE cimatrix operator &(const imatrix_slice &m1,const cmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_CIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//------------- real x complex ------------------------
	INLINE cimatrix operator |(const rmatrix &rv1, const cmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &rv1, const rmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &rv, const rmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const rmatrix_slice &sl,const cmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &sl, const rmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const rmatrix &rv,const cmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &sl1, const rmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const rmatrix_slice &sl1, const cmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	

//------------- complex x complex ------------------------
	INLINE cimatrix operator |(const cmatrix &rv1, const cmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &rv1, const cmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &rv, const cmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &sl,const cmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &sl, const cmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix &rv,const cmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &sl1, const cmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	INLINE cimatrix operator |(const cmatrix_slice &sl1, const cmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<cimatrix>);
#else
	throw();
#endif
	

//============== Compare Operator ==========================

//-------------- Matrix - Matrix   -------------------------

	INLINE bool operator ==(const cimatrix &m1,const cimatrix &m2) throw();
	INLINE bool operator !=(const cimatrix &m1,const cimatrix &m2) throw();
	INLINE bool operator <(const cimatrix &m1,const cimatrix &m2) throw();
	INLINE bool operator <=(const cimatrix &m1,const cimatrix &m2) throw();
	INLINE bool operator >(const cimatrix &m1,const cimatrix &m2) throw();
	INLINE bool operator >=(const cimatrix &m1,const cimatrix &m2) throw();
	INLINE bool operator ==(const cimatrix &m1,const cimatrix_slice &ms) throw();
	INLINE bool operator !=(const cimatrix &m1,const cimatrix_slice &ms) throw();
	INLINE bool operator <(const cimatrix &m1,const cimatrix_slice &ms) throw();
	INLINE bool operator <=(const cimatrix &m1,const cimatrix_slice &ms) throw();
	INLINE bool operator >(const cimatrix &m1,const cimatrix_slice &ms) throw();
	INLINE bool operator >=(const cimatrix &m1,const cimatrix_slice &ms) throw();

//---------------- Matrix - Matrix_slice ----------------------

	INLINE bool operator ==(const cimatrix_slice &m1,const cimatrix_slice &m2) throw();
	INLINE bool operator !=(const cimatrix_slice &m1,const cimatrix_slice &m2) throw();
	INLINE bool operator <(const cimatrix_slice &m1,const cimatrix_slice &m2) throw();
	INLINE bool operator <=(const cimatrix_slice &m1,const cimatrix_slice &m2) throw();
	INLINE bool operator >(const cimatrix_slice &m1,const cimatrix_slice &m2) throw();
	INLINE bool operator >=(const cimatrix_slice &m1,const cimatrix_slice &m2) throw();

//=================== Not Operator =============================

	INLINE bool operator !(const cimatrix &ms) throw();
	INLINE bool operator !(const cimatrix_slice &ms) throw();

//======================== Input / Output ========================

	INLINE std::ostream &operator <<(std::ostream &s,const cimatrix &r) throw();
	INLINE std::ostream &operator <<(std::ostream &s,const cimatrix_slice &r) throw();
	INLINE std::istream &operator >>(std::istream &s,cimatrix &r) throw();
	INLINE std::istream &operator >>(std::istream &s,cimatrix_slice &r) throw();

} // namespace cxsc 


#ifdef _CXSC_INCL_INL
#include "matrix.inl"
#include "cimatrix.inl"
#endif


#endif

