/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: limatrix.hpp,v 1.5 2001/08/09 12:52:39 cxsc Exp $ */

#ifndef _CXSC_LIMATRIX_HPP_INCLUDED
#define _CXSC_LIMATRIX_HPP_INCLUDED

#include "xscclass.hpp"
#include "idot.hpp"
#include "livector.hpp"
#include "except.hpp"
#include "matrix.hpp"
#include "imatrix.hpp"
#include "lrmatrix.hpp"

namespace cxsc {

class l_imatrix;
class l_imatrix_slice;

class l_imatrix_subv
{
	friend class l_ivector;
	friend class l_imatrix;
	friend class l_imatrix_slice;
	private:
	l_interval *dat;
	int lb,ub;
	int size,start,offset; // start=first element index 0..n-1
	
	public:
	friend INLINE l_imatrix_subv Row(l_imatrix &m,const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	friend INLINE l_imatrix_subv Col(l_imatrix &m,const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
//#if(IndCheck)
#ifdef _CXSC_FRIEND_TPL
	//----------------- Templates ---------------------------------------
template <class MV1,class MV2> friend  MV1 &_mvmvassign(MV1 &v,const MV2 &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV1>);
#else
	throw();
#endif
template <class MV,class S> friend  MV &_mvsassign(MV &v,const  S &r) throw();
template <class MV,class V> friend  MV &_mvvassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV2,class S> friend  V &_vmvassign(V &v,const MV2 &rv) throw();
template <class MV,class V> friend  MV &_mvvsetinf(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsetsup(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvusetinf(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvusetsup(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsetre(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsetim(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class MV,class V> friend  V _mvabs(const MV &mv) throw();
template <class MV,class V> friend  V _mvdiam(const MV &mv) throw();
template <class MV,class V> friend  V _mvmid(const MV &mv) throw();
template <class MV,class V> friend  V _mvinf(const MV &mv) throw();
template <class MV,class V> friend  V _mvsup(const MV &mv) throw();

 template <class MV,class S> friend 	 MV &_mvssetinf(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvssetsup(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvsusetinf(MV &mv, const S &s) throw();
 template <class MV,class S> friend 	 MV &_mvsusetsup(MV &mv, const S &s) throw();

template <class DP,class V,class SV> friend 	 void _vmvaccu(DP &dp, const V & rv1, const SV &rv2)
#if(IndCheck)
		throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
template <class DP,class MV1,class MV2> friend 	 void _mvmvaccu(DP &dp, const MV1 & rv1, const MV2 &rv2)
#if(IndCheck)
		throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
 template <class MV1,class MV2,class S> friend 	 S _mvmvlimult(const MV1 & rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MV1>);
#else
	throw();
#endif
 template <class V,class MV,class S> friend 	 S _vmvlimult(const V &rv1, const MV &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
 template <class MV,class S,class E> friend 	 E _mvsmult(const MV &rv, const S &s) throw();
 template <class MV1,class MV2,class E> friend 	 E _mvmvplus(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV1,class MV2,class E> friend 	 E _mvmvminus(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvplus(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvminus(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class V,class MV,class E> friend 	 E _vmvminus(const V &rv1, const MV &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class S,class E> friend 	 E _mvsdiv(const MV &rv, const S &s) throw();
template <class MV,class S> friend  MV &_mvsmultassign(MV &v,const S &r) throw();
template <class MV, class S> friend  MV &_mvsplusassign(MV &v,const S &r) throw();
template <class MV,class S> friend  MV &_mvsminusassign(MV &v,const S &r) throw();
template <class MV,class S> friend  MV &_mvsdivassign(MV &v,const S &r) throw();
template <class MV,class V> friend  MV &_mvvplusassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV> friend  V &_vmvplusassign(V &rv,const MV &v)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<V>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvminusassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV> friend  V &_vmvminusassign(V &rv,const MV &v)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<V>);
#else
	throw();
#endif
 template <class MV1,class MV2,class E> friend 	 E _mvmvconv(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvconv(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvconvassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
 template <class MV1,class MV2,class E> friend 	 E _mvmvsect(const MV1 &rv1, const MV2 &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MV,class V,class E> friend 	 E _mvvsect(const MV &rv1, const V &rv2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
template <class MV,class V> friend  MV &_mvvsectassign(MV &v,const V &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<MV>);
#else
	throw();
#endif
template <class V,class MV> friend  V &_vmvsectassign(V &rv,const MV &v)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<V>);
#else
	throw();
#endif


#endif

	//----------------- Konstruktoren ----------------------------------

	explicit INLINE l_imatrix_subv (l_interval *d, const int &l, const int &u, const int &s, const int &st, const int &o) throw():dat(d),lb(l),ub(u),size(s),start(st),offset(o) { }
	protected:
	INLINE l_imatrix_subv(const l_imatrix_subv &v) throw():dat(v.dat),lb(v.lb),ub(v.ub),size(v.size),start(v.start),offset(v.offset) { }
	public:

	//---------------------- Standardfunktionen ------------------------

	INLINE l_imatrix_subv &operator =(const l_imatrix_subv &rv) throw();
	INLINE l_imatrix_subv &operator =(const l_interval &r) throw();
	INLINE l_imatrix_subv &operator =(const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_imatrix_slice &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_ivector &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_ivector_slice &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// Real
	INLINE l_imatrix_subv &operator =(const real &r) throw();
	INLINE l_imatrix_subv &operator =(const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const rmatrix_slice &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const rvector &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const rvector_slice &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const rmatrix_subv &rv) throw();

	// l_real
	INLINE l_imatrix_subv &operator =(const l_real &r) throw();
	INLINE l_imatrix_subv &operator =(const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_rmatrix_slice &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_rvector &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_rvector_slice &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const l_rmatrix_subv &rv) throw();

	// interval
	INLINE l_imatrix_subv &operator =(const interval &r) throw();
	INLINE l_imatrix_subv &operator =(const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const imatrix_slice &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const ivector &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const ivector_slice &v)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator =(const imatrix_subv &rv) throw();

	friend INLINE int Lb(const l_imatrix_subv &rv) throw() { return rv.lb; }
	friend INLINE int Ub(const l_imatrix_subv &rv) throw() { return rv.ub; }
	INLINE l_interval &operator [](const int &i) const
#if(IndCheck)
	throw(ERROR_LIVECTOR_ELEMENT_NOT_IN_VEC);
#else
	throw();
#endif
	INLINE l_imatrix_subv &operator ()() throw() { return *this; }
	INLINE l_imatrix_subv operator ()(const int &i)
#if(IndCheck)
	throw(ERROR_LIVECTOR_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE l_imatrix_subv operator ()(const int &i1,const int &i2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	
	INLINE l_imatrix_subv &l_imatrix_subv::operator *=(const l_interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const l_interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const l_interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator /=(const l_interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const l_ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const l_ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const l_ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const l_ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const l_ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const l_ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const l_ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const l_ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// real
	INLINE l_imatrix_subv &l_imatrix_subv::operator *=(const real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator /=(const real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// l_real
	INLINE l_imatrix_subv &l_imatrix_subv::operator *=(const l_real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const l_real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const l_real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator /=(const l_real &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const l_rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const l_rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const l_rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const l_rvector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// interval
	INLINE l_imatrix_subv &l_imatrix_subv::operator *=(const interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator /=(const interval &c) throw();
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator -=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator +=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator |=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const ivector &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &l_imatrix_subv::operator &=(const ivector_slice &rv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
//#else
//#endif	

};


//----------------------- Matrix -----------------------------------------------

class l_imatrix_slice;

class l_imatrix
{
	friend class l_imatrix_slice;
	friend class l_imatrix_subv;
	private:
	l_interval *dat;
	int lb1,ub1,lb2,ub2,xsize,ysize;

	public:
//#if(IndCheck)
#ifdef _CXSC_FRIEND_TPL
	//----------------- Templates ---------------------------------------
template <class S,class M> friend  void _smconstr(S &s,const M &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<M>,ERROR__USE_OF_UNINITIALIZED_OBJ<M>);
#else
	throw();
#endif
template <class V,class M,class S> friend  void _vmconstr(V &v,const M &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<M>);
#else
	throw();
#endif
 template <class M1,class M2,class S> friend 	 M1 &_mmassign(M1 &m1,const M2 &m,S ms) throw();
 template <class M,class MS2,class S> friend 	 M &_mmsassign(M &m,const MS2 &ms) throw();
 template <class MS,class M> friend 	 MS &_msmassign(MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class M,class S> friend 	 M &_msassign(M &m,const S &r) throw();
template <class V,class M,class S> friend  V &_vmassign(V &v,const M &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<M>);
#else
	throw();
#endif
template <class M,class V,class S> friend  M &_mvassign(M &m,const V &v) throw();
 template <class M> friend 	 int _mlb(const M &m, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 int _mub(const M &m, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 M &_msetlb(M &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 M &_msetub(M &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<M>);
#else
	throw();
#endif
 template <class M> friend 	 void _mresize(M &A) throw();
 template <class M,class S> friend 	 void _mresize(M &A,const int &m, const int &n)
#if(IndCheck)
		throw(ERROR__WRONG_BOUNDARIES<M>);
#else
	throw();
#endif
 template <class M,class S> friend 	 void _mresize(M &A,const int &m1, const int &m2,const int &n1,const int &n2)
#if(IndCheck)
		throw(ERROR__WRONG_BOUNDARIES<M>);
#else
	throw();
#endif
 template <class M,class E> friend 	 E _mabs(const M &m) throw();
 template <class MS,class E> friend 	 E _msabs(const MS &ms) throw();
 template <class M,class E> friend 	 E _mdiam(const M &m) throw();
 template <class M,class E> friend 	 E _mmid(const M &m) throw();
 template <class M,class E> friend 	 E _minf(const M &m) throw();
 template <class M,class E> friend 	 E _msup(const M &m) throw();
 template <class M1,class M2> friend 	 M1 &_mmsetinf(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmsetsup(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetinf(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetsup(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmusetinf(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmusetsup(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmsusetinf(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmsusetsup(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
	//-------------- matrix-matrix -------------
 template <class M1,class M2,class E> friend 	 E _mmplus(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsplus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M> friend 	 M _mminus(const M &m) throw();
 template <class MS,class E> friend 	 E _msminus(const MS &ms) throw();
 template <class M1,class M2,class E> friend 	 E _mmminus(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmplusassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsplusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmplusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsplus(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsminus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmminus(const MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsminus(const MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmminusassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsminusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmminusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class M1,class M2,class E> friend 	 E _mmlimult(const M1 &m1, const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2,class S> friend 	 M1 &_mmlimultassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmslimult(const M &m1, const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmlimult(const MS &ms, const M &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class S> friend 	 M &_mmslimultassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmslimult(const MS1 &ms1, const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2,class E> friend 	 E _mmconv(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsconv(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmconvassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsconvassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmconvassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsconv(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M1,class M2,class E> friend 	 E _mmsect(const M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmssect(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M1,class M2> friend 	 M1 &_mmsectassign(M1 &m1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmssectassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmsectassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmssect(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
	//-------- matrix-scalar -----------------
 template <class S,class M,class E> friend 	 E _smmult(const S &c, const M &m) throw();
 template <class M,class S> friend 	 M &_msmultassign(M &m,const S &c) throw();
 template <class S,class MS,class E> friend 	 E _smsmult(const S &c, const MS &ms) throw();
 template <class M,class S,class E> friend 	 E _msdiv(const M &m,const S &c) throw();
 template <class M,class S> friend 	 M &_msdivassign(M &m,const S &c) throw();
 template <class MS,class S,class E> friend 	 E _mssdiv(const MS &ms, const S &c) throw();
	//-------- matrix-vector ---------------------
 template <class M,class V,class E> friend 	 E _mvlimult(const M &m,const V &v)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class V,class M,class E> friend 	 E _vmlimult(const V &v,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class V,class M,class S> friend 	 V &_vmlimultassign(V &v,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class VS,class M,class S> friend 	 VS &_vsmlimultassign(VS &v,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
	
 template <class M> friend 	 void *_mvoid(const M &m) throw();
 template <class M> friend 	 bool _mnot(const M &m) throw();
 template <class MS> friend 	 void *_msvoid(const MS &ms) throw();
 template <class MS> friend 	 bool _msnot(const MS &ms) throw();
 template <class M1,class M2> friend 	 bool _mmeq(const M1 &m1,const M2 &m2) throw();
 template <class M1,class M2> friend 	 bool _mmneq(const M1 &m1,const M2 &m2) throw();
 template <class M1,class M2> friend 	 bool _mmless(const M1 &m1,const M2 &m2) throw();
 template <class M1,class M2> friend 	 bool _mmleq(const M1 &m1,const M2 &m2) throw();
 template <class M,class MS> friend 	 bool _mmseq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsneq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsless(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsleq(const M &m1,const MS &ms) throw();
 template <class MS,class M> friend 	 bool _msmless(const MS &ms,const M &m1) throw();
 template <class MS,class M> friend 	 bool _msmleq(const MS &ms,const M &m1) throw();
 template <class M> friend 	std::ostream &_mout(std::ostream &s,const M &r) throw();
 template <class M> friend 	std::istream &_min(std::istream &s,M &r) throw();

	//--- Real --------- matrix-scalar ----------------------
 template <class M1,class MS2> friend 	 M1 &_mmssetre(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif
 template <class M1,class MS2> friend 	 M1 &_mmssetim(M1 &m1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M1>);
#else
	throw();
#endif

	//--- Real --------- matrix-vector ----------------------
 template <class MS,class V,class E> friend 	 E _msvlimult(const MS &ms,const V &v)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class V,class MS,class E> friend 	 E _vmslimult(const V &v,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif


#endif
	
	//--------------------------  Konstruktoren ----------------------------

// l_interval
	INLINE l_imatrix(const l_imatrix &rm) throw();
	INLINE l_imatrix(const l_imatrix_slice &rm) throw();
	INLINE l_imatrix() throw();
	explicit INLINE l_imatrix(const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif
	explicit INLINE l_imatrix(const int &m1, const int &n1, const int &m2, const int &n2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif
	explicit INLINE l_imatrix(const l_ivector &v) throw();
	explicit INLINE l_imatrix(const l_ivector_slice &v) throw();
	explicit INLINE l_imatrix(const l_interval &r) throw();
	INLINE l_imatrix &operator =(const l_interval &r) throw();
	INLINE l_imatrix &operator =(const l_imatrix &m) throw();
	INLINE l_imatrix &operator =(const l_imatrix_slice &ms) throw();
	INLINE l_imatrix &operator =(const l_ivector &v) throw();
	INLINE l_imatrix &operator =(const l_ivector_slice &v) throw();
//  real
	explicit INLINE l_imatrix(const real &r) throw();
	explicit INLINE l_imatrix(const rmatrix &rm) throw();
	explicit INLINE l_imatrix(const rmatrix_slice &rm) throw();
	explicit INLINE l_imatrix(const rvector &v) throw();
	explicit INLINE l_imatrix(const rvector_slice &v) throw();
	INLINE l_imatrix &operator =(const real &r) throw();
	INLINE l_imatrix &operator =(const rmatrix &m) throw();
	INLINE l_imatrix &operator =(const rmatrix_slice &ms) throw();
	INLINE l_imatrix &operator =(const rvector &v) throw();
	INLINE l_imatrix &operator =(const rvector_slice &v) throw();

//  l_real
	explicit INLINE l_imatrix(const l_real &r) throw();
	explicit INLINE l_imatrix(const l_rmatrix &rm) throw();
	explicit INLINE l_imatrix(const l_rmatrix_slice &rm) throw();
	explicit INLINE l_imatrix(const l_rvector &v) throw();
	explicit INLINE l_imatrix(const l_rvector_slice &v) throw();
	INLINE l_imatrix &operator =(const l_real &r) throw();
	INLINE l_imatrix &operator =(const l_rmatrix &m) throw();
	INLINE l_imatrix &operator =(const l_rmatrix_slice &ms) throw();
	INLINE l_imatrix &operator =(const l_rvector &v) throw();
	INLINE l_imatrix &operator =(const l_rvector_slice &v) throw();

//  interval
	explicit INLINE l_imatrix(const interval &r) throw();
	explicit INLINE l_imatrix(const imatrix &rm) throw();
	explicit INLINE l_imatrix(const imatrix_slice &rm) throw();
	explicit INLINE l_imatrix(const ivector &v) throw();
	explicit INLINE l_imatrix(const ivector_slice &v) throw();
	INLINE l_imatrix &operator =(const interval &r) throw();
	INLINE l_imatrix &operator =(const imatrix &m) throw();
	INLINE l_imatrix &operator =(const imatrix_slice &ms) throw();
	INLINE l_imatrix &operator =(const ivector &v) throw();
	INLINE l_imatrix &operator =(const ivector_slice &v) throw();

	//--------------------------- Destruktoren -----------------------------

	INLINE ~l_imatrix() throw() { delete [] dat; }

	//------------------------- Standardfunktionen -------------------------

	INLINE l_imatrix_subv operator [](const int &i) const
#if(IndCheck)
	throw(ERROR_LIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE l_imatrix_subv operator [](const cxscmatrix_column &i) const
#if(IndCheck)
	throw(ERROR_LIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE l_imatrix &operator ()() throw() { return *this; }
	INLINE l_imatrix_slice operator ()(const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_LIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE l_imatrix_slice operator ()(const int &m1, const int &m2, const int &n1, const int &n2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE operator void*() throw();
//#else
//#endif
};

	
class l_imatrix_slice
{
	friend class l_imatrix;
	private:
	l_interval *dat;
	int offset1,offset2,mxsize,mysize;
	int start1,end1,start2,end2,sxsize,sysize;     // slice size

	public:
//#if(IndCheck)
#ifdef _CXSC_FRIEND_TPL
	//----------------- Templates ---------------------------------------
template <class V,class MS,class S> friend  void _vmsconstr(V &v,const MS &m)
#if(IndCheck)
	throw(ERROR__TYPE_CAST_OF_THICK_OBJ<MS>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmassign(MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsassign(MS1 &ms1,const MS2 &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class M,class MS2,class S> friend 	 M &_mmsassign(M &m,const MS2 &ms) throw();
 template <class MS,class S> friend 	 MS &_mssassign(MS &ms,const S &r) throw();
 template <class MS> friend 	 int _mslb(const MS &ms, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<MS>);
#else
	throw();
#endif
 template <class MS> friend 	 int _msub(const MS &ms, const int &i)
#if(IndCheck)
	throw(ERROR__WRONG_ROW_OR_COL<MS>);
#else
	throw();
#endif
 template <class MS,class E> friend 	 E _msabs(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msinf(const MS &ms) throw();
 template <class MS,class E> friend 	 E _mssup(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msdiam(const MS &ms) throw();
 template <class MS,class E> friend 	 E _msmid(const MS &ms) throw();
 template <class MS1,class M2> friend 	 MS1 &_msmsetinf(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmsetsup(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssetinf(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssetsup(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmusetinf(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class M2> friend 	 MS1 &_msmusetsup(MS1 &ms1,const M2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsusetinf(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsusetsup(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
	//-------- matrix-matrix --------------
 template <class MS,class E> friend 	 E _msminus(const MS &ms) throw();
 template <class M,class MS,class E> friend 	 E _mmsplus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsplus(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsplusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmplusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsplusassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsminus(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmminus(const MS &ms,const M &m)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsminus(const MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsminusassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmminusassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsminusassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmslimult(const M &m1, const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class MS,class M,class E> friend 	 E _msmlimult(const MS &ms, const M &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class S> friend 	 M &_mmslimultassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmslimult(const MS1 &ms1, const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmsconv(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmsconvassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmconvassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmsconvassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmsconv(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
 template <class M,class MS,class E> friend 	 E _mmssect(const M &m,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class M,class MS> friend 	 M &_mmssectassign(M &m1,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<M>);
#else
	throw();
#endif
 template <class MS,class M> friend 	 MS &_msmsectassign(MS &ms,const M &m1)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class MS1,class MS2> friend 	 MS1 &_msmssectassign(MS1 &ms1,const MS2 &ms2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS1>);
#else
	throw();
#endif
 template <class MS1,class MS2,class E> friend 	 E _msmssect(const MS1 &m1,const MS2 &m2)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<E>);
#else
	throw();
#endif
	//--------- matrix-vector --------------
 template <class MS,class V,class E> friend 	 E _msvlimult(const MS &ms,const V &v)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class V,class MS,class E> friend 	 E _vmslimult(const V &v,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
 template <class V,class MS,class S> friend 	 V &_vmslimultassign(V &v,const MS &ms)
#if(IndCheck)
		throw(ERROR__OP_WITH_WRONG_DIM<MS>);
#else
	throw();
#endif
	//--------- matrix-scalar --------------
 template <class S,class MS,class E> friend 	 E _smsmult(const S &c, const MS &ms) throw();
 template <class MS,class S> friend 	 MS &_mssmultassign(MS &ms,const S &c) throw();
 template <class MS,class S,class E> friend 	 E _mssdiv(const MS &ms, const S &c) throw();
 template <class MS,class S> friend 	 MS &_mssdivassign(MS &ms,const S &c) throw();
	
 template <class MS> friend 	 void *_msvoid(const MS &ms) throw();
 template <class MS> friend 	 bool _msnot(const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmseq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsneq(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsless(const M &m1,const MS &ms) throw();
 template <class M,class MS> friend 	 bool _mmsleq(const M &m1,const MS &ms) throw();
 template <class MS,class M> friend 	 bool _msmless(const MS &ms,const M &m1) throw();
 template <class MS,class M> friend 	 bool _msmleq(const MS &ms,const M &m1) throw();
 template <class MS1,class MS2> friend 	 bool _msmseq(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS1,class MS2> friend 	 bool _msmsneq(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS1,class MS2> friend 	 bool _msmsless(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS1,class MS2> friend 	 bool _msmsleq(const MS1 &ms1,const MS2 &ms2) throw();
 template <class MS> friend 	std::ostream &_msout(std::ostream &s,const MS &r) throw();
 template <class MS> friend 	std::istream &_msin(std::istream &s,MS &r) throw();


#endif

	//--------------- Konstruktoren ----------------------------------------

	explicit INLINE l_imatrix_slice(l_imatrix &a,const int &l1,const int &u1,const int &l2, const int &u2) throw():dat(a.dat),offset1(l1-a.lb1),offset2(l2-a.lb2),mxsize(a.xsize),mysize(a.ysize),start1(l1),end1(u1),start2(l2),end2(u2),sxsize(u2-l2+1),sysize(u1-l1+1) { }
	explicit INLINE l_imatrix_slice(l_imatrix_slice &a,const int &l1,const int &u1,const int &l2, const int &u2) throw():dat(a.dat),offset1(a.offset1+l1-a.start1),offset2(a.offset2+l2-a.start2),mxsize(a.mxsize),mysize(a.mysize),start1(l1),end1(u1),start2(l2),end2(u2),sxsize(u2-l2+1),sysize(u1-l1+1) { }
	protected: 
	INLINE l_imatrix_slice(const l_imatrix_slice &ms) throw():dat(ms.dat),offset1(ms.offset1),offset2(ms.offset2),mxsize(ms.mxsize),mysize(ms.mysize),start1(ms.start1),end1(ms.end1),start2(ms.start2),end2(ms.end2),sxsize(ms.sxsize),sysize(ms.sysize) { }
	public:

	//---------------- Standardfunktionen -----------------------------------

	friend INLINE l_ivector::l_ivector(const l_imatrix_slice &sl)
#if(IndCheck)
	throw(ERROR_LIMATRIX_TYPE_CAST_OF_THICK_OBJ);
#else
	throw();
#endif
	friend INLINE l_imatrix::l_imatrix(const l_imatrix_slice &) throw();
	INLINE l_imatrix_slice &operator =(const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_interval &r) throw();
	INLINE l_imatrix_slice &operator =(const l_ivector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_ivector_slice &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_imatrix_subv &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	// real
	INLINE l_imatrix_slice &operator =(const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const real &r) throw();
	INLINE l_imatrix_slice &operator =(const rvector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const rvector_slice &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const rmatrix_subv &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	// interval
	INLINE l_imatrix_slice &operator =(const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const interval &r) throw();
	INLINE l_imatrix_slice &operator =(const ivector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const ivector_slice &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const imatrix_subv &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	// l_real
	INLINE l_imatrix_slice &operator =(const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_real &r) throw();
	INLINE l_imatrix_slice &operator =(const l_rvector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_rvector_slice &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator =(const l_rmatrix_subv &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_imatrix_subv operator [](const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE l_imatrix_subv operator [](const cxscmatrix_column &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_ROW_OR_COL_NOT_IN_MAT);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator ()() throw() { return *this; }
	INLINE l_imatrix_slice operator ()(const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_LIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE l_imatrix_slice operator ()(const int &m1, const int &m2, const int &n1, const int &n2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_SUB_ARRAY_TOO_BIG);
#else
	throw();
#endif
	INLINE l_imatrix_slice::operator void*() throw();

	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const l_interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const l_interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator *=(const l_interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator /=(const l_interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator *=(const real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator /=(const real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const l_real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const l_real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator *=(const l_real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator /=(const l_real &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const l_rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const l_rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const l_rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const l_rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator *=(const interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator /=(const interval &c) throw();
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator +=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator -=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator |=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &l_imatrix_slice::operator &=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &operator *=(const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

//#else
//#endif
};

//================================================================
//====================== Subvector Functions =====================

//=======================Vector / Scalar =========================

	INLINE l_ivector operator /(const l_imatrix_subv &rv, const l_interval &s) throw();
	INLINE l_ivector operator *(const l_imatrix_subv &rv, const l_interval &s) throw();
	INLINE l_ivector operator *(const l_interval &s, const l_imatrix_subv &rv) throw();
	INLINE l_ivector abs(const l_imatrix_subv &mv) throw();
	INLINE l_rvector diam(const l_imatrix_subv &mv) throw();
	INLINE l_rvector mid(const l_imatrix_subv &mv) throw();
	INLINE l_rvector Inf(const l_imatrix_subv &mv) throw();
	INLINE l_rvector Sup(const l_imatrix_subv &mv) throw();
	INLINE l_imatrix_subv &SetInf(l_imatrix_subv &iv,const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &SetSup(l_imatrix_subv &iv,const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &UncheckedSetInf(l_imatrix_subv &iv,const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_subv &UncheckedSetSup(l_imatrix_subv &iv,const l_rvector &rv)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_imatrix_subv &SetSup(l_imatrix_subv &iv,const l_real &r) throw();
	INLINE l_imatrix_subv &SetInf(l_imatrix_subv &iv,const l_real &r) throw();
	INLINE l_imatrix_subv &UncheckedSetSup(l_imatrix_subv &iv,const l_real &r) throw();
	INLINE l_imatrix_subv &SetUncheckedInf(l_imatrix_subv &iv,const l_real &r) throw();

//======================== Vector / Vector ========================

	
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_ivector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const l_ivector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_ivector_slice & sl1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const l_ivector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_interval operator *(const l_imatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_interval operator *(const l_ivector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_interval operator *(const l_imatrix_subv &rv1,const l_ivector &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_interval operator *(const l_ivector_slice &sl,const l_imatrix_subv &sv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_interval operator *(const l_imatrix_subv &mv,const l_ivector_slice &vs)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_ivector operator +(const l_imatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator +(const l_imatrix_subv &rv1,const l_ivector &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator +(const l_ivector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator +(const l_ivector_slice &sl,const l_imatrix_subv &mv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator +(const l_imatrix_subv &mv,const l_ivector_slice &sl)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_ivector operator -(const l_imatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator -(const l_ivector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator -(const l_imatrix_subv &rv1,const l_ivector &rv2)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator -(const l_ivector_slice &sl,const l_imatrix_subv &mv)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator -(const l_imatrix_subv &mv,const l_ivector_slice &sl)
#if(IndCheck)
	throw(ERROR_LIVECTOR_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

//  real

	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const rmatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const rvector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const rvector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const rvector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const rmatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const rvector_slice & sl1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
// l_real

	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const l_rmatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const l_rvector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const l_rvector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_rvector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_rmatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_rvector_slice & sl1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
// interval

	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const ivector_slice &sl2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_imatrix_subv & rv1, const ivector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const ivector & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const imatrix_subv & rv1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const ivector_slice & sl1, const l_imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	

//====================================================================
//===================== Matrix Functions =============================

	INLINE l_imatrix _imatrix(const l_imatrix &rm) throw();
	INLINE l_imatrix _imatrix(const l_ivector &v) throw();
	INLINE l_imatrix _imatrix(const l_ivector_slice &v) throw();
	INLINE l_imatrix _imatrix(const l_interval &r) throw();

	INLINE int Lb(const l_imatrix &rm, const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE int Ub(const l_imatrix &rm, const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE int Lb(const l_imatrix_slice &rm, const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE int Ub(const l_imatrix_slice &rm, const int &i)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE l_imatrix &SetLb(l_imatrix &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE l_imatrix &SetUb(l_imatrix &m, const int &i,const int &j)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_ROW_OR_COL);
#else
	throw();
#endif
	INLINE void Resize(l_imatrix &A) throw();
	INLINE void Resize(l_imatrix &A,const int &m, const int &n)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif
	INLINE void Resize(l_imatrix &A,const int &m1, const int &m2,const int &n1,const int &n2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_WRONG_BOUNDARIES);
#else
	throw();
#endif

	INLINE l_imatrix abs(const l_imatrix &m) throw();
	INLINE l_imatrix abs(const l_imatrix_slice &ms) throw();
	INLINE l_rmatrix diam(const l_imatrix &m) throw();
	INLINE l_rmatrix diam(const l_imatrix_slice &m) throw();
	INLINE l_rmatrix mid(const l_imatrix &m) throw();
	INLINE l_rmatrix mid(const l_imatrix_slice &m) throw();
	INLINE l_rmatrix Inf(const l_imatrix &m) throw();
	INLINE l_rmatrix Sup(const l_imatrix &m) throw();
	INLINE l_rmatrix Inf(const l_imatrix_slice &m) throw();
	INLINE l_rmatrix Sup(const l_imatrix_slice &m) throw();
	INLINE l_imatrix &SetInf(l_imatrix &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &SetInf(l_imatrix_slice &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &SetInf(l_imatrix &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &SetInf(l_imatrix_slice &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &SetSup(l_imatrix &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &SetSup(l_imatrix_slice &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &SetSup(l_imatrix &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &SetSup(l_imatrix_slice &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &UncheckedSetInf(l_imatrix &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &UncheckedSetInf(l_imatrix_slice &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &UncheckedSetInf(l_imatrix &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &UncheckedSetInf(l_imatrix_slice &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &UncheckedSetSup(l_imatrix &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &UncheckedSetSup(l_imatrix_slice &cm,const l_rmatrix &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &UncheckedSetSup(l_imatrix &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix_slice &UncheckedSetSup(l_imatrix_slice &cm,const l_rmatrix_slice &rm)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

//===================== Matrix / Scalar ===============================

	INLINE l_imatrix operator *(const l_interval &c, const l_imatrix &m) throw();
	INLINE l_imatrix operator *(const l_interval &c, const l_imatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const l_imatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator *(const l_imatrix_slice &ms,const l_interval &c) throw();
	INLINE l_imatrix &operator *=(l_imatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator /(const l_imatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator /(const l_imatrix_slice &ms, const l_interval &c) throw();
	INLINE l_imatrix &operator /=(l_imatrix &m,const l_interval &c) throw();
	
//------------ real - l_imatrix -----------------------------------------------

	INLINE l_imatrix operator *(const real &c, const l_imatrix &m) throw();
	INLINE l_imatrix operator *(const real &c, const l_imatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const l_imatrix &m,const real &c) throw();
	INLINE l_imatrix operator *(const l_imatrix_slice &ms,const real &c) throw();
	INLINE l_imatrix &operator *=(l_imatrix &m,const real &c) throw();
	INLINE l_imatrix operator /(const l_imatrix &m,const real &c) throw();
	INLINE l_imatrix operator /(const l_imatrix_slice &ms, const real &c) throw();
	INLINE l_imatrix &operator /=(l_imatrix &m,const real &c) throw();
//----------------- rmatrix - l_interval ----------------

	INLINE l_imatrix operator *(const l_interval &c, const rmatrix &m) throw();
	INLINE l_imatrix operator *(const l_interval &c, const rmatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const rmatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator *(const rmatrix_slice &ms,const l_interval &c) throw();
	INLINE l_imatrix operator /(const rmatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator /(const rmatrix_slice &ms, const l_interval &c) throw();
	
//------------ l_real - l_imatrix -----------------------------------------------

	INLINE l_imatrix operator *(const l_real &c, const l_imatrix &m) throw();
	INLINE l_imatrix operator *(const l_real &c, const l_imatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const l_imatrix &m,const l_real &c) throw();
	INLINE l_imatrix operator *(const l_imatrix_slice &ms,const l_real &c) throw();
	INLINE l_imatrix &operator *=(l_imatrix &m,const l_real &c) throw();
	INLINE l_imatrix operator /(const l_imatrix &m,const l_real &c) throw();
	INLINE l_imatrix operator /(const l_imatrix_slice &ms, const l_real &c) throw();
	INLINE l_imatrix &operator /=(l_imatrix &m,const l_real &c) throw();
//----------------- l_rmatrix - l_interval ----------------

	INLINE l_imatrix operator *(const l_interval &c, const l_rmatrix &m) throw();
	INLINE l_imatrix operator *(const l_interval &c, const l_rmatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const l_rmatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator *(const l_rmatrix_slice &ms,const l_interval &c) throw();
	INLINE l_imatrix operator /(const l_rmatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator /(const l_rmatrix_slice &ms, const l_interval &c) throw();
	
//------------ interval - l_imatrix -----------------------------------------------

	INLINE l_imatrix operator *(const interval &c, const l_imatrix &m) throw();
	INLINE l_imatrix operator *(const interval &c, const l_imatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const l_imatrix &m,const interval &c) throw();
	INLINE l_imatrix operator *(const l_imatrix_slice &ms,const interval &c) throw();
	INLINE l_imatrix &operator *=(l_imatrix &m,const interval &c) throw();
	INLINE l_imatrix operator /(const l_imatrix &m,const interval &c) throw();
	INLINE l_imatrix operator /(const l_imatrix_slice &ms, const interval &c) throw();
	INLINE l_imatrix &operator /=(l_imatrix &m,const interval &c) throw();
//----------------- imatrix - l_interval ----------------

	INLINE l_imatrix operator *(const l_interval &c, const imatrix &m) throw();
	INLINE l_imatrix operator *(const l_interval &c, const imatrix_slice &ms) throw();
	INLINE l_imatrix operator *(const imatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator *(const imatrix_slice &ms,const l_interval &c) throw();
	INLINE l_imatrix operator /(const imatrix &m,const l_interval &c) throw();
	INLINE l_imatrix operator /(const imatrix_slice &ms, const l_interval &c) throw();
	

//============================ Matrix / Vector ===================================


	INLINE l_ivector operator *(const l_imatrix &m,const l_ivector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_imatrix_slice &ms,const l_ivector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_ivector &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_ivector &v,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector &operator *=(l_ivector &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector &operator *=(l_ivector &v,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif

	INLINE l_ivector operator *(const l_ivector_slice &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_ivector_slice &v,const l_imatrix_slice &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//----------------- real -------------------------------------

	INLINE l_ivector operator *(const rvector &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const rvector &v,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const rvector_slice &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_ivector operator *(const l_imatrix &m,const rvector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_imatrix_slice &ms,const rvector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//----------------- l_real -------------------------------------

	INLINE l_ivector operator *(const l_rvector &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_rvector &v,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_rvector_slice &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_ivector operator *(const l_imatrix &m,const l_rvector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_imatrix_slice &ms,const l_rvector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//----------------- interval -------------------------------------

	INLINE l_ivector operator *(const ivector &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const ivector &v,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const ivector_slice &v,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_ivector operator *(const l_imatrix &m,const ivector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_ivector operator *(const l_imatrix_slice &ms,const ivector &v)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	

//================ Matrix / Matrix ============================

	INLINE const l_imatrix &operator +(const l_imatrix &m1) throw();
	INLINE l_imatrix operator +(const l_imatrix_slice &ms) throw();
	INLINE l_imatrix operator +(const l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator -(const l_imatrix &m) throw();
	INLINE l_imatrix operator -(const l_imatrix_slice &ms) throw();
	INLINE l_imatrix operator -(const l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms1,const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator *(const l_imatrix &m1, const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms, const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms1, const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	
	INLINE l_imatrix operator |(const l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator &(const l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- rmatrix-l_imatrix ------------------
	INLINE l_imatrix operator +(const rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const rmatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &m1,const rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator -(const rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const rmatrix_slice &ms1,const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms1,const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator *(const rmatrix &m1, const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const rmatrix &m1, const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const rmatrix_slice &ms, const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms, const rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const rmatrix_slice &ms1, const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms1, const rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator |(const rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const rmatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &m1,const rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator &(const rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &ms,const rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const rmatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &m1,const rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- l_rmatrix-l_imatrix ------------------
	INLINE l_imatrix operator +(const l_rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_rmatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &m1,const l_rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator -(const l_rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_rmatrix_slice &ms1,const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms1,const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator *(const l_rmatrix &m1, const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_rmatrix &m1, const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_rmatrix_slice &ms, const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms, const l_rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_rmatrix_slice &ms1, const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms1, const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator |(const l_rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &m1,const l_rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator &(const l_rmatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_rmatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_rmatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_rmatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &m1,const l_rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- imatrix-l_imatrix ------------------
	INLINE l_imatrix operator +(const imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_imatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator +=(l_imatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator -(const imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix_slice &ms1,const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_imatrix_slice &ms1,const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator -=(l_imatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator *(const imatrix &m1, const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix &m1, const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix &m1, const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix_slice &ms, const l_imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms, const imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix_slice &ms1, const l_imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_imatrix_slice &ms1, const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator *=(l_imatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator |(const imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_imatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator |=(l_imatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator &(const imatrix &m1,const l_imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix &m,const l_imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix_slice &ms,const l_imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix_slice &m1,const l_imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_imatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix &operator &=(l_imatrix &m1,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	//---------- l_rmatrix-imatrix ------------------
	INLINE l_imatrix operator +(const l_rmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_rmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_rmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const l_rmatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator +(const imatrix_slice &m1,const l_rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator -(const l_rmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_rmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_rmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const l_rmatrix_slice &ms1,const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator -(const imatrix_slice &ms1,const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator *(const l_rmatrix &m1, const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix &m1, const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_rmatrix &m1, const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix &m1, const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_rmatrix_slice &ms, const imatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix_slice &ms, const l_rmatrix &m1)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const l_rmatrix_slice &ms1, const imatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator *(const imatrix_slice &ms1, const l_rmatrix_slice &ms2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator |(const l_rmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const imatrix_slice &m1,const l_rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
	INLINE l_imatrix operator &(const l_rmatrix &m1,const imatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix &m1,const l_rmatrix &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_rmatrix &m,const imatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix &m,const l_rmatrix_slice &ms)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_rmatrix_slice &ms,const imatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix_slice &ms,const l_rmatrix &m)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const l_rmatrix_slice &m1,const imatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE l_imatrix operator &(const imatrix_slice &m1,const l_rmatrix_slice &m2)
#if(IndCheck)
	throw(ERROR_LIMATRIX_OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	
//------------- real x l_real ------------------------
	INLINE l_imatrix operator |(const rmatrix &rv1, const l_rmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &rv1, const rmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &rv, const rmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const rmatrix_slice &sl,const l_rmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &sl, const rmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const rmatrix &rv,const l_rmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &sl1, const rmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const rmatrix_slice &sl1, const l_rmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	

//------------- l_real x l_real ------------------------
	INLINE l_imatrix operator |(const l_rmatrix &rv1, const l_rmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &rv1, const l_rmatrix &rv2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &rv, const l_rmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &sl,const l_rmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &sl, const l_rmatrix &rv)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix &rv,const l_rmatrix_slice &sl)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &sl1, const l_rmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	INLINE l_imatrix operator |(const l_rmatrix_slice &sl1, const l_rmatrix_slice &sl2)
#if(IndCheck)
	throw(ERROR__OP_WITH_WRONG_DIM<l_imatrix>);
#else
	throw();
#endif
	

//============== Compare Operator ==========================

//-------------- Matrix - Matrix   -------------------------

	INLINE bool operator ==(const l_imatrix &m1,const l_imatrix &m2) throw();
	INLINE bool operator !=(const l_imatrix &m1,const l_imatrix &m2) throw();
	INLINE bool operator <(const l_imatrix &m1,const l_imatrix &m2) throw();
	INLINE bool operator <=(const l_imatrix &m1,const l_imatrix &m2) throw();
	INLINE bool operator >(const l_imatrix &m1,const l_imatrix &m2) throw();
	INLINE bool operator >=(const l_imatrix &m1,const l_imatrix &m2) throw();
	INLINE bool operator ==(const l_imatrix &m1,const l_imatrix_slice &ms) throw();
	INLINE bool operator !=(const l_imatrix &m1,const l_imatrix_slice &ms) throw();
	INLINE bool operator <(const l_imatrix &m1,const l_imatrix_slice &ms) throw();
	INLINE bool operator <=(const l_imatrix &m1,const l_imatrix_slice &ms) throw();
	INLINE bool operator >(const l_imatrix &m1,const l_imatrix_slice &ms) throw();
	INLINE bool operator >=(const l_imatrix &m1,const l_imatrix_slice &ms) throw();

//---------------- Matrix - Matrix_slice ----------------------

	INLINE bool operator ==(const l_imatrix_slice &m1,const l_imatrix_slice &m2) throw();
	INLINE bool operator !=(const l_imatrix_slice &m1,const l_imatrix_slice &m2) throw();
	INLINE bool operator <(const l_imatrix_slice &m1,const l_imatrix_slice &m2) throw();
	INLINE bool operator <=(const l_imatrix_slice &m1,const l_imatrix_slice &m2) throw();
	INLINE bool operator >(const l_imatrix_slice &m1,const l_imatrix_slice &m2) throw();
	INLINE bool operator >=(const l_imatrix_slice &m1,const l_imatrix_slice &m2) throw();

//=================== Not Operator =============================

	INLINE bool operator !(const l_imatrix &ms) throw();
	INLINE bool operator !(const l_imatrix_slice &ms) throw();

//======================== Input / Output ========================

	INLINE std::ostream &operator <<(std::ostream &s,const l_imatrix &r) throw();
	INLINE std::ostream &operator <<(std::ostream &s,const l_imatrix_slice &r) throw();
	INLINE std::istream &operator >>(std::istream &s,l_imatrix &r) throw();
	INLINE std::istream &operator >>(std::istream &s,l_imatrix_slice &r) throw();

} // namespace cxsc 

#ifdef _CXSC_INCL_INL
#include "matrix.inl"
#include "limatrix.inl"
#endif


#endif

