/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: t_name.h,v 1.2 2001/07/26 12:23:01 cxsc Exp $ */

/****************************************************************/
/*                                                              */
/*      Filename        : t_name.h                              */
/*                                                              */
/*      Description     : Name definitions for tenbyte routines */
/*                                                              */
/****************************************************************/

/*--------------------------------------------------------------*/
/*      Entry name substitution                                 */
/*--------------------------------------------------------------*/
#define absee                   t_abse
#define acosee                  t_acse
#define acoshee                 t_ache
#define acosviatan              t_acvt
#define acotee                  t_acte
#define acothee                 t_athe
#define adddd                   t_dadd
#define asinee                  t_asne
#define asinhee                 t_ashe
#define asinviatan              t_asvt
#define atanee                  t_atne
#define atanhee                 t_anhe
#define chk_1                   t_chk1
#define chk_arg_1               t_cha1
#define chk_arg_2               t_cha2
#define chk_arg_i1              t_chi1
#define chk_arg_i2              t_chi2
#define chk_extreal             t_cher
#define chk_ival                t_chiv
#define chsee                   t_chse
#define cmpabsee                t_cmae
#define cmpabsdd                t_dcma
#define cmpdd                   t_dcmp
#define cmpee                   t_cmpe
#define cond_to_exc             t_ctoe
#define copydd                  t_dcpy
#define copyee                  t_cpye
#define cosee                   t_cose
#define coshee                  t_cshe
#define cotee                   t_cote
#define cothee                  t_cthe
#define dadd                    t_addd
#define default_handle_1        t_dhl1
#define default_handle_2        t_dhl2
#define default_handle_i1       t_dhi1
#define default_handle_i2       t_dhi2
#define dmadjust                t_dadj
#define dmshift                 t_dsft
#define dmulee                  t_dmle
#define dreal_to_2extreal       t_dt2e
#define dreal_to_extreal        t_dtoe
#define dsub                    t_subd
#define emshift                 t_esft
#define exc_handle_1            t_ehl1
#define exc_handle_2            t_ehl2
#define exc_handle_i1           t_ehi1
#define exc_handle_i2           t_ehi2
#define excfct_to_a             t_efta
#define exc_to_a                t_etoa
#define expee                   t_expe
#define expm1ee                 t_exme
#define extreal_to_dreal        t_etod
#define extreal_to_int          t_etoi
#define extreal_to_longreal     t_etol
#define fprinte                 t_fpte
#define gza_trg                 t_gtrg
#define iabsee                  t_iabe
#define iacosee                 t_iase
#define iacoshee                t_ibse
#define iacotee                 t_iate
#define iacothee                t_ibte
#define iasinee                 t_iane
#define iasinhee                t_ibne
#define iatanee                 t_iaae
#define iatanhee                t_ibae
#define ichsee                  t_ichs
#define icopyee                 t_icpe
#define icosee                  t_icse
#define icoshee                 t_ishe
#define icotee                  t_icte
#define icothee                 t_ithe
#define ieee_aborti1            t_abi1
#define ieee_aborti2            t_abi2
#define ieee_abortr1            t_abr1
#define ieee_abortr2            t_abr2
#define ieee_matherr            t_merr
#define iexpee                  t_iepe
#define ilnee                   t_ilne
#define initd                   t_dini
#define ipowee                  t_ipwe
#define irndintee               t_irde
#define iround_abs              t_iras
#define iround_rel              t_irrl
#define isincos                 t_is_c
#define isinee                  t_isne
#define isinhee                 t_inhe
#define isqrtee                 t_isqe
#define itanee                  t_itne
#define itanhee                 t_iahe
#define lnee                    t_lnee
#define lnp1ee                  t_lnpe
#define longreal_to_extreal     t_ltoe
#define mantcmp                 t_mcmp
#define mod2e                   t_md2e
#define mod4e                   t_md4e
#define msg_exc                 t_mexc
#define msg_exctyp              t_mtyp
#define msplitee                t_mspe
#define muldd                   t_dmul
#define muled                   t_emul
#define mulendpi                t_mnpi
#define mulLdE                  t_deml
#define normd                   t_dnrm
#define powee                   t_powe
#define powsub                  t_pows
#define printe                  t_prte
#define pxsccode                t_pcde
#define red_trg                 t_rtrg
#define rndintee                t_rdie
#define round_abs               t_rabs
#define round_ln                t_r_ln
#define round_rel               t_rrel
#define _s_2xm1                 t_s2xm
#define _s_atan                 t_satn
#define _s_chk_invalid          t_sinv
#define _s_etoi                 t_sei_
#define _s_etoie                t_seie
#define _s_etol                 t_sel_
#define _s_ln                   t_s_ln
#define _s_lnp1                 t_s_lp
#define _s_ltoe                 t_sle_
#define _s_sin                  t_ssin
#define _s_sqrt                 t_sqt_
#define _s_tan                  t_stan
#define _s_xam                  t_sxam
#define scalee                  t_scee
#define scaliee                 t_scie
#define sincos                  t_sico
#define sinee                   t_sine
#define sinhee                  t_snhe
#define sqrtee                  t_sqte
#define sqrtm1ee                t_sqme
#define sround                  t_sron
#define subdd                   t_dsub
#define tancot                  t_tnct
#define tanee                   t_tane
#define tanhee                  t_tnhe
#define xtracte                 t_xtre
#define xtrexpe                 t_xtpe

/*--------------------------------------------------------------*/
/*      Variable name substitution                              */
/*--------------------------------------------------------------*/
#define arg_check               t_achk
#define DOne                    t_done
#define Eight                   t_eigh
#define EpsACos                 t_pacs
#define EpsACot                 t_pact
#define EpsASin                 t_pasn
#define EpsATan                 t_patn
#define EpsACosh                t_pbsh
#define EpsACoth                t_pbth
#define EpsASinh                t_pbnh
#define EpsATanh                t_pbah
#define EpsCos                  t_pcos
#define EpsCosh                 t_pcsh
#define EpsCot                  t_pcot
#define EpsCoth                 t_pcth
#define EpsExp                  t_pexp
#define EpsLn                   t_pln_
#define EpsLnAbs                t_plna
#define EpsLnRel                t_plnr
#define EpsPow                  t_ppow
#define EpsSin                  t_psin
#define EpsSinh                 t_psnh
#define EpsSqrt                 t_psqt
#define EpsTan                  t_ptan
#define EpsTanh                 t_ptnh
#define Four                    t_four
#define Half                    t_half
#define IHalf                   t_ihlf
#define IntMax                  t_imax
#define IntMin                  t_imin
#define IOne                    t_ione
#define IPi                     t_ipi_
#define IPiHalf                 t_ipih
#define ISqrtTwo                t_isq2
#define ITwoDivPi               t_i2op
#define LdE                     t_lde_
#define Ln2                     t_ln_2
#define LongRealDenormMin       t_ldmn
#define LongRealMax             t_lmax
#define LongRealMin             t_lmin
#define MaxArgExp               t_xaex
#define MinArgExp               t_maex
#define MaxArgHyp               t_xahy
#define MinArgHyp               t_mahy
#define MaxArgLnp1              t_xalp
#define MaxArgSqrtm1            t_xasm
#define MaxNormExtReal          t_xner
#define MinExtReal              t_mer_
#define MInfty                  t_minf
#define MinNormExtReal          t_mner
#define MinusOne                t_mone
#define MinusPi                 t_mpi_
#define MinusPiHalf             t_mpo2
#define One                     t_pone
#define Pi                      t_ppi_
#define Pi3Div16                t_pp3_
#define PiDiv16                 t_pp16
#define PiDiv8                  t_pp_8
#define PiHalf                  t_ppo2
#define PiQuart                 t_ppo4
#define PInfty                  t_pinf
#define Quarter                 t_1qua
#define SqrtHalf                t_sqth
#define SqrtTwo                 t_sqtt
#define ThreeQuart              t_3qua
#define Two                     t_two_
#define TwoPow127               t_t127
#define TwoPow63                t_to63
#define Zero                    t_zero






