/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1999
*
*	File:	AnchorNode.h
*
******************************************************************/

#ifndef _ANCHOR_H_
#define _ANCHOR_H_

#include "vrmlfields.h"
#include "GroupingNode.h"

class AnchorNode : public GroupingNode {

public:

	AnchorNode();
	~AnchorNode(); 

	////////////////////////////////////////////////
	//	Description
	////////////////////////////////////////////////

	void	setDescription(String value);
	String	getDescription();

	////////////////////////////////////////////////
	// Parameter
	////////////////////////////////////////////////

	void	addParameter(String value);
	int		getNParameters();
	String	getParameter(int index);

	////////////////////////////////////////////////
	// Url
	////////////////////////////////////////////////

	void	addUrl(String value);
	int		getNUrls();
	String	getUrl(int index);
	void	setUrl(int index, char *urlString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	AnchorNode	*next();
	AnchorNode	*nextTraversal();

	////////////////////////////////////////////////
	//	virtual functions
	////////////////////////////////////////////////

	bool	isChildNodeType(Node *node);
	void	initialize();
	void	uninitialize();
	void	update();
	void	outputContext(ostream &printStream, String indentString);

};

#endif
