/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	AppearanceNode.h
*
******************************************************************/

#ifndef _APPEARANCE_H_
#define _APPEARANCE_H_

#include "vrmlfields.h"
#include "Node.h"
#include "MaterialNode.h"
#include "TextureTransformNode.h"

class AppearanceNode : public Node {

public:

	AppearanceNode();
	~AppearanceNode();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	AppearanceNode *next();
	AppearanceNode *nextTraversal();

	////////////////////////////////////////////////
	//	virtual functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();
	void outputContext(ostream &printStream, String indentString);
};

#endif
