/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	BillboardNode.h
*
******************************************************************/

#ifndef _BILLBOARD_H_
#define _BILLBOARD_H_

#include "vrmlfields.h"
#include "Node.h"
	
class BillboardNode : public GroupingNode {

public:

	BillboardNode();
	~BillboardNode();

	////////////////////////////////////////////////
	//	axisOfRotation
	////////////////////////////////////////////////

	void setAxisOfRotation(float value[]);
	void setAxisOfRotation(float x, float y, float z);
	void getAxisOfRotation(float value[]);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	BillboardNode *next();
	BillboardNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	actions
	////////////////////////////////////////////////

	void	getBillboardToViewerVector(float vector[3]);
	void	getViewerToBillboardVector(float vector[3]);
	void	getPlaneVectorOfAxisOfRotationAndBillboardToViewer(float vector[3]);
	void	getZAxisVectorOnPlaneOfAxisOfRotationAndBillboardToViewer(float vector[3]);
	float	getRotationAngleOfZAxis();
	void	getRotationZAxisRotation(float rotation[4]);
	void	getSFMatrix(SFMatrix *mOut);

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

