/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	BoxNode.h
*
******************************************************************/

#ifndef _BOX_H_
#define _BOX_H_

#include "vrmlfields.h"
#include "GeometryNode.h"

class BoxNode : public GeometryNode {
	
public:

	BoxNode();
	~BoxNode();

	////////////////////////////////////////////////
	//	size
	////////////////////////////////////////////////

	void setSize(float value[]);
	void setSize(float x, float y, float z);
	void getSize(float value[]);
	float getX();
	float getY();
	float getZ();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	BoxNode *next();
	BoxNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL
	void recomputeDisplayList();
#endif

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif
