/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CLinkedList.h
*
******************************************************************/

#ifndef _CLINKEDLIST_H_
#define _CLINKEDLIST_H_

#include "CLinkedListNode.h"

template <class T>
class CLinkedList {

	CLinkedListNode<T>	*mHeaderNode;		

public:

	CLinkedList () {
		mHeaderNode = new CLinkedListNode<T>(1);
	}

	~CLinkedList () {
		deleteNodes();
		delete mHeaderNode;
	}

	void setRootNode(CLinkedListNode<T> *obj) {
		mHeaderNode = obj;
	}

	T *getRootNode () {
		return (T *)mHeaderNode;
	}

	T *getNodes () {
		return (T *)mHeaderNode->next();
	}

	T *getNode (int number) {
		if (number < 0)
			return (T *)NULL;
		CLinkedListNode<T> *node = (CLinkedListNode<T> *)getNodes();
		for (int n=0; n<number && node; n++)
			node = (CLinkedListNode<T> *)node->next();
		return (T *)node;
	}

	T *getLastNode () {
		CLinkedListNode<T> *lastNode = (CLinkedListNode<T> *)mHeaderNode->prev();
		if (lastNode->isHeaderNode())
			return NULL;
		else
			return (T *)lastNode;
	}

	int getNNodes()	{
		int n = 0;
		for (CLinkedListNode<T> *listNode = (CLinkedListNode<T> *)getNodes(); listNode; listNode = (CLinkedListNode<T> *)listNode->next())
			n++;
		return n;
	}

	void addNode(CLinkedListNode<T> *node) {
		node->remove();
		node->insert((CLinkedListNode<T> *)mHeaderNode->prev());
	}

	void addNodeAtFirst(CLinkedListNode<T> *node) {
		node->remove();
		node->insert(mHeaderNode);
	}

	void deleteNodes() {
		CLinkedListNode<T> *rootNode = (CLinkedListNode<T> *)getRootNode();
		if (!rootNode)
			return;
		while (rootNode->next())
			delete rootNode->mNextNode;
	}
};

#endif

