/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CollisionNode.h
*
******************************************************************/

#ifndef _COLLISION_H_
#define _COLLISION_H_

#include "GroupingNode.h"

class CollisionNode : public GroupingNode {

public:

	CollisionNode();
	~CollisionNode();

	////////////////////////////////////////////////
	//	collide
	////////////////////////////////////////////////

	void setCollide(bool  value);
	void setCollide(int value);
	bool getCollide();

	////////////////////////////////////////////////
	//	collideTime
	////////////////////////////////////////////////

	void setcollideTime(double value);
	double getcollideTime();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	CollisionNode *next();
	CollisionNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

