/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ColorInterpolatorNode.h
*
******************************************************************/

#ifndef _COLORINTERPOLATOR_H_
#define _COLORINTERPOLATOR_H_

#include "Node.h"

class ColorInterpolatorNode : public Node {

public:

	ColorInterpolatorNode();
	~ColorInterpolatorNode();

	////////////////////////////////////////////////
	//	key
	////////////////////////////////////////////////
	
	void addKey(float value);
	int getNKeys();
	float getKey(int index);
	Field *getKeyField();

	////////////////////////////////////////////////
	//	keyValue
	////////////////////////////////////////////////
	
	void addKeyValue(float color[]);
	int getNKeyValues();
	void getKeyValue(int index, float color[]);
	Field *getKeyValueField();

	////////////////////////////////////////////////
	//	fraction
	////////////////////////////////////////////////
	
	void setFraction(float value);
	float getFraction();
	Field *getFractionField();

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////
	
	void setValue(float color[]);
	void getValue(float color[]);
	Field *getValueField();

	////////////////////////////////////////////////
	//	Virtual functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ColorInterpolatorNode *next();
	ColorInterpolatorNode *nextTraversal();

};

#endif
