/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ColorNode.h
*
******************************************************************/

#ifndef _COLOR_H_
#define _COLOR_H_

#include "vrmlfields.h"
#include "Node.h"

class ColorNode : public Node {

public:

	ColorNode();
	~ColorNode();

	////////////////////////////////////////////////
	//	color
	////////////////////////////////////////////////
	
	void addColor(float color[]);
	int getNColors();
	void getColor(int index, float color[]);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ColorNode *next();
	ColorNode *nextTraversal();

};

#endif
