/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CylinderNode.h
*
******************************************************************/

#ifndef _CYLINDER_H_
#define _CYLINDER_H_

#include "GeometryNode.h"

class CylinderNode : public GeometryNode {

public:

	CylinderNode();
	~CylinderNode();

	////////////////////////////////////////////////
	//	radius
	////////////////////////////////////////////////

	void setRadius(float value);
	float getRadius();

	////////////////////////////////////////////////
	//	height
	////////////////////////////////////////////////

	void setHeight(float value);
	float getHeight();

	////////////////////////////////////////////////
	//	top
	////////////////////////////////////////////////

	void setTop(bool value);
	void setTop(int value);
	bool getTop();

	////////////////////////////////////////////////
	//	side
	////////////////////////////////////////////////

	void setSide(bool value);
	void setSide(int value);
	bool getSide();

	////////////////////////////////////////////////
	//	bottom
	////////////////////////////////////////////////

	void setBottom(bool  value);
	void setBottom(int value);
	bool  getBottom();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	CylinderNode *next();
	CylinderNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL
	void recomputeDisplayList();
#endif

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

