/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ElevationGridNode.h
*
******************************************************************/

#ifndef _ELEVATIONGRID_H_
#define _ELEVATIONGRID_H_

#include "GeometryNode.h"
#include "ColorNode.h"
#include "NormalNode.h"
#include "TextureCoordinateNode.h"

class ElevationGridNode : public GeometryNode {

public:

	ElevationGridNode();
	~ElevationGridNode();

	////////////////////////////////////////////////
	//	xSpacing
	////////////////////////////////////////////////

	void setXSpacing(float value);
	float getXSpacing();

	////////////////////////////////////////////////
	//	zSpacing
	////////////////////////////////////////////////

	void setZSpacing(float value);
	float getZSpacing();

	////////////////////////////////////////////////
	//	xDimension
	////////////////////////////////////////////////

	void setXDimension(int value);
	int getXDimension();

	////////////////////////////////////////////////
	//	zDimension
	////////////////////////////////////////////////

	void setZDimension(int value);
	int getZDimension();

	////////////////////////////////////////////////
	//	ColorPerVertex
	////////////////////////////////////////////////
	
	void setColorPerVertex(bool  value);
	void setColorPerVertex(int value);
	bool  getColorPerVertex();

	////////////////////////////////////////////////
	//	NormalPerVertex
	////////////////////////////////////////////////
	
	void setNormalPerVertex(bool  value);
	void setNormalPerVertex(int value);
	bool  getNormalPerVertex();

	////////////////////////////////////////////////
	//	CCW
	////////////////////////////////////////////////
	
	void setCCW(bool  value);
	void setCCW(int value);
	bool  getCCW();

	////////////////////////////////////////////////
	//	Solid
	////////////////////////////////////////////////
	
	void setSolid(bool  value);
	void setSolid(int value);
	bool  getSolid();

	////////////////////////////////////////////////
	//	CreaseAngle
	////////////////////////////////////////////////
	
	void setCreaseAngle(float value);
	float getCreaseAngle();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ElevationGridNode *next();
	ElevationGridNode *nextTraversal();

	////////////////////////////////////////////////
	// height
	////////////////////////////////////////////////

	void addHeight(float value);
	int getNHeights();
	float getHeight(int index);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

	void recomputeDisplayList();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

