/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	IndexedFaceSetNode.h
*
******************************************************************/

#ifndef _INDEXEDFACESET_H_
#define _INDEXEDFACESET_H_

#include "GeometryNode.h"
#include "NormalNode.h"
#include "ColorNode.h"
#include "CoordinateNode.h"
#include "TextureCoordinateNode.h"

class IndexedFaceSetNode : public GeometryNode {
	
public:

	IndexedFaceSetNode();
	~IndexedFaceSetNode();
	
	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	IndexedFaceSetNode *next();
	IndexedFaceSetNode *nextTraversal();

	////////////////////////////////////////////////
	//	CCW
	////////////////////////////////////////////////
	
	void setCCW(bool value);
	void setCCW(int value);
	bool getCCW();

	////////////////////////////////////////////////
	//	ColorPerVertex
	////////////////////////////////////////////////
	
	void setColorPerVertex(bool value);
	void setColorPerVertex(int value);
	bool getColorPerVertex();

	////////////////////////////////////////////////
	//	NormalPerVertex
	////////////////////////////////////////////////
	
	void setNormalPerVertex(bool value);
	void setNormalPerVertex(int value);
	bool getNormalPerVertex();

	////////////////////////////////////////////////
	//	Solid
	////////////////////////////////////////////////
	
	void setSolid(bool value);
	void setSolid(int value);
	bool getSolid();

	////////////////////////////////////////////////
	//	Convex
	////////////////////////////////////////////////
	
	void setConvex(bool value);
	void setConvex(int value);
	bool getConvex();

	////////////////////////////////////////////////
	//	CreaseAngle
	////////////////////////////////////////////////
	
	void setCreaseAngle(float value);
	float getCreaseAngle();

	////////////////////////////////////////////////
	// CoordIndex
	////////////////////////////////////////////////

	void addCoordIndex(int value);
	int getNCoordIndexes();
	int getCoordIndex(int index);
	
	////////////////////////////////////////////////
	// TexCoordIndex
	////////////////////////////////////////////////

	void addTexCoordIndex(int value);
	int getNTexCoordIndexes();
	int getTexCoordIndex(int index);
	
	////////////////////////////////////////////////
	// ColorIndex
	////////////////////////////////////////////////

	void addColorIndex(int value);
	int getNColorIndexes();
	int getColorIndex(int index);

	////////////////////////////////////////////////
	// NormalIndex
	////////////////////////////////////////////////

	void addNormalIndex(int value);
	int getNNormalIndexes();
	int getNormalIndex(int index);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL
	void recomputeDisplayList();
#endif

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	Polygon
	////////////////////////////////////////////////

	int		getNPolygons();

	////////////////////////////////////////////////
	//	Normal
	////////////////////////////////////////////////

	bool generateNormals();

	////////////////////////////////////////////////
	//	TextureCoordinate
	////////////////////////////////////////////////
	
	bool generateTextureCoordinate();

};

#endif

