/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	IndexedLinSet.h
*
******************************************************************/

#ifndef _INDEXEDLINESET_H_
#define _INDEXEDLINESET_H_

#include "GeometryNode.h"
#include "ColorNode.h"
#include "CoordinateNode.h"

class IndexedLineSetNode : public GeometryNode {
	
public:

	IndexedLineSetNode();
	~IndexedLineSetNode();
	
	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	IndexedLineSetNode *next();
	IndexedLineSetNode *nextTraversal();

	////////////////////////////////////////////////
	//	ColorPerVertex
	////////////////////////////////////////////////
	
	void setColorPerVertex(bool value);
	void setColorPerVertex(int value);
	bool getColorPerVertex();

	////////////////////////////////////////////////
	// CoordIndex
	////////////////////////////////////////////////

	void addCoordIndex(int value);
	int getNCoordIndexes();
	int getCoordIndex(int index);
	void clearCoordIndex();
	
	////////////////////////////////////////////////
	// ColorIndex
	////////////////////////////////////////////////

	void addColorIndex(int value);
	int getNColorIndexes();
	int getColorIndex(int index);
	void clearColorIndex();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL
	void recomputeDisplayList();
#endif

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif