/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	InlineNode.h
*
******************************************************************/

#ifndef _INLINE_H_
#define _INLINE_H_

#include "GroupingNode.h"

class InlineNode : public GroupingNode {

public:

	InlineNode();
	~InlineNode();

	////////////////////////////////////////////////
	// Url
	////////////////////////////////////////////////

	void addUrl(String value);
	int getNUrls();
	String getUrl(int index);
	void setUrl(int index, char *urlString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	InlineNode *next();
	InlineNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

