/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	JVector.h
*
******************************************************************/

#ifndef _JVECTOR_H_
#define _JVECTOR_H_
 
#include "CLinkedList.h"

template <class T>
class JVectorElement : public CLinkedListNode<T> {
	int	mbDeleteObject;
	T	*mObj;
public:
	JVectorElement() : CLinkedListNode<T>(1) {
		setObject(NULL);
	}
	JVectorElement(T *obj, bool bDeleteObject = true) : CLinkedListNode<T>((bool)false) {
		mbDeleteObject = bDeleteObject;
		setObject(obj);
	}
	~JVectorElement() { 
		remove();
		if (mbDeleteObject)
			delete mObj;
	}
	void setObject(T *obj)	{
		mObj = obj;
	}
	T *getObject()	{
		return mObj;
	}
};

template <class T>
class JVector {
	CLinkedList<T>	 mElementList;
public:
	
	JVector() {
	}

	~JVector() {
		removeAllElements();
	}

	void addElement(T *obj, bool bDeleteObject = true) {
		JVectorElement<T> *element = new JVectorElement<T>(obj, bDeleteObject);
		mElementList.addNode(element);
	}

	int contains(void *elem) {
		for (int n=0; n<size(); n++) {
			if (elem == elementAt(n))
				return 1;
		}
		return 0;
	}

	T *elementAt(int index) {
		JVectorElement<T> *element = (JVectorElement<T> *)mElementList.getNode(index);
		return element ? element->getObject() : NULL;
	}

	T *firstElement() {
		JVectorElement<T> *element = (JVectorElement<T> *)mElementList.getNodes();
		return element ? element->getObject() : NULL;
	}

	int	indexOf(T *elem) {
		for (int n=0; n<size(); n++) {
			if (elem == elementAt(n))
				return n;
		}
		return -1;
	}

	int indexOf(T *elem, int index) {
		for (int n=index; n<size(); n++) {
			if (elem == elementAt(n))
				return n;
		}
		return -1;
	}

	void	insertElementAt(T *obj, int index, bool bDeleteObject = true) {
		JVectorElement<T> *element = (JVectorElement<T> *)mElementList.getNode(index);
		if (element) {
			JVectorElement<T> *newElement = new JVectorElement<T>(obj, bDeleteObject);
			newElement->insert((JVectorElement<T> *)element->prev());
		}
	}

	bool isEmpty() {
		return mElementList.getNodes() ? false : true;
	}

	T *lastElement() {
		JVectorElement<T> *element = (JVectorElement<T> *)mElementList.getNode(size()-1);
		return element ? element->getObject() : NULL;
	}

	int	lastIndexOf(T *elem);
	int	lastIndexOf(T *elem, int index);

	void removeAllElements() {
		mElementList.deleteNodes();
	}

	void removeElement(T *obj) {
		removeElementAt(indexOf(obj));
	}

	void removeElementAt(int index) {
		JVectorElement<T> *element = (JVectorElement<T> *)mElementList.getNode(index);
		if (element)
			delete element;
	}

	void setElementAt(T *obj, int index) {
		JVectorElement<T> *element = (JVectorElement<T> *)mElementList.getNode(index);
		if (element)  
			element->setObject(obj);
	}

	int	size() {
		return mElementList.getNNodes();
	}
};

#endif 
