/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	MaterialNode.h
*
******************************************************************/

#ifndef _MATERIAL_H_
#define _MATERIAL_H_

#include "vrmlfields.h"
#include "Node.h"

class MaterialNode : public Node {
	
public:

	MaterialNode();
	~MaterialNode();

	////////////////////////////////////////////////
	//	Transparency
	////////////////////////////////////////////////
	
	void setTransparency(float value);
	float getTransparency();

	////////////////////////////////////////////////
	//	AmbientIntensity
	////////////////////////////////////////////////
	
	void setAmbientIntensity(float intensity);
	float getAmbientIntensity();

	////////////////////////////////////////////////
	//	Shininess
	////////////////////////////////////////////////
	
	void setShininess(float value);
	float getShininess();

	////////////////////////////////////////////////
	//	DiffuseColor
	////////////////////////////////////////////////

	void setDiffuseColor(float value[]);
	void setDiffuseColor(float r, float g, float b);
	void getDiffuseColor(float value[]);

	////////////////////////////////////////////////
	//	SpecularColor
	////////////////////////////////////////////////

	void setSpecularColor(float value[]);
	void setSpecularColor(float r, float g, float b);
	void getSpecularColor(float value[]);

	////////////////////////////////////////////////
	//	EmissiveColor
	////////////////////////////////////////////////

	void setEmissiveColor(float value[]);
	void setEmissiveColor(float r, float g, float b);
	void getEmissiveColor(float value[]);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	MaterialNode *next();
	MaterialNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

