/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	MovieTextureNode.h
*
******************************************************************/

#ifndef _MOVIETEXTURE_H_
#define _MOVIETEXTURE_H_

#include "vrmlfields.h"
#include "TextureNode.h"

class MovieTextureNode : public TextureNode {
	
public:

	MovieTextureNode();
	~MovieTextureNode();

	////////////////////////////////////////////////
	//	RepeatS
	////////////////////////////////////////////////
	
	void setRepeatS(bool value);
	void setRepeatS(int value);
	bool getRepeatS();

	////////////////////////////////////////////////
	//	RepeatT
	////////////////////////////////////////////////
	
	void setRepeatT(bool value);
	void setRepeatT(int value);
	bool getRepeatT();

	////////////////////////////////////////////////
	// Url
	////////////////////////////////////////////////

	void addUrl(String value);
	int getNUrls();
	String getUrl(int index);
	void setUrl(int index, char *urlString);

	////////////////////////////////////////////////
	//	Loop
	////////////////////////////////////////////////
	
	void setLoop(bool value);
	void setLoop(int value);
	bool getLoop();
	bool isLoop();

	////////////////////////////////////////////////
	//	Speed
	////////////////////////////////////////////////
	
	void setSpeed(float value);
	float getSpeed();

	////////////////////////////////////////////////
	//	Start time
	////////////////////////////////////////////////
	
	void setStartTime(double value);
	double getStartTime();

	////////////////////////////////////////////////
	//	Stop time
	////////////////////////////////////////////////
	
	void setStopTime(double value);
	double getStopTime();

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool value);
	bool getIsActive();
	bool isActive();

	////////////////////////////////////////////////
	//	duration_changed
	////////////////////////////////////////////////
	
	void setDurationChanged(double value);
	double getDurationChanged();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	MovieTextureNode *next();
	MovieTextureNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Urlmation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif
