/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	NormalInterpolatorNode.h
*
******************************************************************/

#ifndef _NORMALINTERPOLATOR_H_
#define _NORMALINTERPOLATOR_H_

#include "vrmlfields.h"
#include "Node.h"

class NormalInterpolatorNode : public Node {

public:

	NormalInterpolatorNode();
	~NormalInterpolatorNode();

	////////////////////////////////////////////////
	//	key
	////////////////////////////////////////////////
	
	void addKey(float value);
	int getNKeys();
	float getKey(int index);
	Field *getKeyField();

	////////////////////////////////////////////////
	//	keyValue
	////////////////////////////////////////////////
	
	void addKeyValue(float vector[]);
	int getNKeyValues();
	void getKeyValue(int index, float vector[]);
	Field *getKeyValueField();

	////////////////////////////////////////////////
	//	fraction
	////////////////////////////////////////////////
	
	void setFraction(float value);
	float getFraction();
	Field *getFractionField();

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////
	
	void setValue(float vector[]);
	void getValue(float vector[]);
	Field *getValueField();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	NormalInterpolatorNode *next();
	NormalInterpolatorNode *nextTraversal();

};

#endif

