/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	NormalNode.h
*
******************************************************************/

#ifndef _NORMAL_H_
#define _NORMAL_H_

#include "vrmlfields.h"
#include "Node.h"

class NormalNode : public Node {

public:

	NormalNode();
	~NormalNode();

	////////////////////////////////////////////////
	//	vector
	////////////////////////////////////////////////
	
	void addVector(float value[]);
	int getNVectors();
	void getVector(int index, float value[]);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	NormalNode *next();
	NormalNode *nextTraversal();

};

#endif

