/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	PixelTextureNode.h
*
******************************************************************/

#ifndef _PIXELTEXTURE_H_
#define _PIXELTEXTURE_H_

#include "vrmlfields.h"
#include "TextureNode.h"

class PixelTextureNode : public TextureNode {
	
public:

	PixelTextureNode();
	~PixelTextureNode();

	////////////////////////////////////////////////
	//	RepeatS
	////////////////////////////////////////////////
	
	void setRepeatS(bool value);
	void setRepeatS(int value);
	bool getRepeatS();

	////////////////////////////////////////////////
	//	RepeatT
	////////////////////////////////////////////////
	
	void setRepeatT(bool value);
	void setRepeatT(int value);
	bool getRepeatT();

	////////////////////////////////////////////////
	// Image
	////////////////////////////////////////////////

	void addImage(int value);
	int getNImages();
	int getImage(int index);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	PixelTextureNode *next();
	PixelTextureNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Imagemation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

