/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ProximitySensorNode.h
*
******************************************************************/

#ifndef _PROXIMITYSENSOR_H_
#define _PROXIMITYSENSOR_H_

#include "vrmlfields.h"
#include "Node.h"

#define	inRegionPrivateFieldString	"inRegion"

class ProximitySensorNode : public Node {
	
public:

	ProximitySensorNode();
	~ProximitySensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void setEnabled(bool value);
	void setEnabled(int value);
	bool getEnabled();
	bool  isEnabled();

	////////////////////////////////////////////////
	//	Center
	////////////////////////////////////////////////
	
	void setCenter(float value[]);
	void setCenter(float x, float y, float z);
	void getCenter(float value[]);

	////////////////////////////////////////////////
	//	Size
	////////////////////////////////////////////////
	
	void setSize(float value[]);
	void setSize(float x, float y, float z);
	void getSize(float value[]);

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool  value);
	void setIsActive(int value);
	bool  getIsActive();
	bool  isActive();

	////////////////////////////////////////////////
	//	Position
	////////////////////////////////////////////////
	
	void setPositionChanged(float value[]);
	void setPositionChanged(float x, float y, float z);
	void getPositionChanged(float value[]);

	////////////////////////////////////////////////
	//	Orientation
	////////////////////////////////////////////////
	
	void setOrientationChanged(float value[]);
	void setOrientationChanged(float x, float y, float z, float rot);
	void getOrientationChanged(float value[]);

	////////////////////////////////////////////////
	//	EnterTime
	////////////////////////////////////////////////
	
	void setEnterTime(double value);
	double getEnterTime();

	////////////////////////////////////////////////
	//	ExitTime
	////////////////////////////////////////////////
	
	void setExitTime(double value);
	double getExitTime();

	////////////////////////////////////////////////
	//	inRegion
	////////////////////////////////////////////////

	void setInRegion(bool value);
	bool inRegion();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ProximitySensorNode *next();
	ProximitySensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

