/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ScalarInterpolatorNode.h
*
******************************************************************/

#ifndef _SCALARINTERPOLATOR_H_
#define _SCALARINTERPOLATOR_H_

#include "vrmlfields.h"
#include "Node.h"

class ScalarInterpolatorNode : public Node {

public:

	ScalarInterpolatorNode();
	~ScalarInterpolatorNode();

	////////////////////////////////////////////////
	//	key
	////////////////////////////////////////////////
	
	void addKey(float value);
	int getNKeys();
	float getKey(int index);
	Field *getKeyField();

	////////////////////////////////////////////////
	//	keyValue
	////////////////////////////////////////////////
	
	void addKeyValue(float value);
	int getNKeyValues();
	float getKeyValue(int index);
	Field *getKeyValueField();

	////////////////////////////////////////////////
	//	fraction
	////////////////////////////////////////////////
	
	void setFraction(float value);
	float getFraction();
	Field *getFractionField();
	Field *getValueField();

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////
	
	void setValue(float vector);
	float getValue();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ScalarInterpolatorNode *next();
	ScalarInterpolatorNode *nextTraversal();
};

#endif
