/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ScriptNode.h
*
******************************************************************/

#ifndef _SCRIPT_H_
#define _SCRIPT_H_

#include "vrmlfields.h"
#include "Node.h"
#include "JString.h"
#include "CJavaVM.h"
#include "JScript.h"

#ifdef SUPPORT_JSAI
class ScriptNode : public Node, public CJavaVM { 
#else
class ScriptNode : public Node { 
#endif

#ifdef SUPPORT_JSAI
	JScript			*mpJScriptNode;
#endif

public:

	ScriptNode();
	~ScriptNode();

	////////////////////////////////////////////////
	// Initialization
	////////////////////////////////////////////////

	void initialize();
	void uninitialize();

	////////////////////////////////////////////////
	// DirectOutput
	////////////////////////////////////////////////

	void setDirectOutput(bool  value);
	void setDirectOutput(int value);
	bool  getDirectOutput();

	////////////////////////////////////////////////
	// MustEvaluate
	////////////////////////////////////////////////

	void setMustEvaluate(bool  value);
	void setMustEvaluate(int value);
	bool  getMustEvaluate();

	////////////////////////////////////////////////
	// Url
	////////////////////////////////////////////////

	void addUrl(String value);
	int getNUrls();
	String getUrl(int index);
	void setUrl(int index, char *urlString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ScriptNode *next();
	ScriptNode *nextTraversal();

	////////////////////////////////////////////////
	//	virtual function
	////////////////////////////////////////////////

	bool isChildNodeType(Node *node);

	////////////////////////////////////////////////
	//	update
	////////////////////////////////////////////////

	void update();

	////////////////////////////////////////////////
	//	output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	// JSAI
	////////////////////////////////////////////////

#ifdef SUPPORT_JSAI

	int hasScript() {
		return getJavaNode() ? 1 : 0;
	}

	JScript	*getJavaNode()	{return mpJScriptNode;}

#endif

	////////////////////////////////////////////////
	// Update Java Fields
	////////////////////////////////////////////////

	void	update(Field *eventInField);
	void	updateFields();
};

#endif

