/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ShapeNode.h
*
******************************************************************/

#ifndef _SHAPE_H_
#define _SHAPE_H_

#include "vrmlfields.h"
#include "Node.h"
#include "AppearanceNode.h"
#include "GeometryNode.h"

class ShapeNode : public Node {

public:

	ShapeNode();
	~ShapeNode();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ShapeNode *next();
	ShapeNode *nextTraversal();

	////////////////////////////////////////////////
	//	Geometry
	////////////////////////////////////////////////

	GeometryNode *getGeometry();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

