/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	SpotLightNode.h
*
******************************************************************/

#ifndef _SPOTLIGHT_H_
#define _SPOTLIGHT_H_

#include "LightNode.h"

class SpotLightNode : public LightNode {
	
public:

	SpotLightNode();
	~SpotLightNode();

	////////////////////////////////////////////////
	//	AmbientIntensity
	////////////////////////////////////////////////
	
	void setAmbientIntensity(float value);
	float getAmbientIntensity();

	////////////////////////////////////////////////
	//	Location
	////////////////////////////////////////////////

	void setLocation(float value[]);
	void setLocation(float x, float y, float z);
	void getLocation(float value[]);

	////////////////////////////////////////////////
	//	Direction
	////////////////////////////////////////////////

	void setDirection(float value[]);
	void setDirection(float x, float y, float z);
	void getDirection(float value[]);

	////////////////////////////////////////////////
	//	Radius
	////////////////////////////////////////////////
	
	void setRadius(float value);
	float getRadius();

	////////////////////////////////////////////////
	//	Attenuation
	////////////////////////////////////////////////

	void setAttenuation(float value[]);
	void setAttenuation(float x, float y, float z);
	void getAttenuation(float value[]);

	////////////////////////////////////////////////
	//	BeamWidth
	////////////////////////////////////////////////
	
	void setBeamWidth(float value);
	float getBeamWidth();

	////////////////////////////////////////////////
	//	CutOffAngle
	////////////////////////////////////////////////
	
	void setCutOffAngle(float value);
	float getCutOffAngle();

	////////////////////////////////////////////////
	//	Diffuse Color
	////////////////////////////////////////////////

	void getDiffuseColor(float value[]);

	////////////////////////////////////////////////
	//	Ambient Color
	////////////////////////////////////////////////

	void getAmbientColor(float value[]);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	SpotLightNode *next();
	SpotLightNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif
