/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	TextureTransformNode.h
*
******************************************************************/

#ifndef _TEXTURETRANSFORM_H_
#define _TEXTURETRANSFORM_H_

#include "vrmlfields.h"
#include "Node.h"

class TextureTransformNode : public Node {

public:

	TextureTransformNode();
	~TextureTransformNode();

	////////////////////////////////////////////////
	//	Translation
	////////////////////////////////////////////////

	void setTranslation(float value[]);
	void setTranslation(float x, float y);
	void getTranslation(float value[]);

	////////////////////////////////////////////////
	//	Scale
	////////////////////////////////////////////////

	void setScale(float value[]);
	void setScale(float x, float y);
	void getScale(float value[]);

	////////////////////////////////////////////////
	//	Center
	////////////////////////////////////////////////

	void setCenter(float value[]);
	void setCenter(float x, float y);
	void getCenter(float value[]);

	////////////////////////////////////////////////
	//	Rotation
	////////////////////////////////////////////////

	void setRotation(float value);
	float getRotation();

	////////////////////////////////////////////////
	//	Texture Matrix
	////////////////////////////////////////////////

	void getSFMatrix(SFMatrix *matrix);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	TextureTransformNode *next();
	TextureTransformNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

