/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	TimeSensorNode.h
*
******************************************************************/

#ifndef _TIMESENSOR_H_
#define _TIMESENSOR_H_

#include <time.h>
#ifdef WIN32
#include <sys/timeb.h>
#endif
#include "vrmlfields.h"
#include "Node.h"

class TimeSensorNode : public Node {

public:

	TimeSensorNode();
	~TimeSensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void setEnabled(bool value);
	void setEnabled(int value);
	bool getEnabled();
	bool isEnabled();
	Field *getEnabledField();

	////////////////////////////////////////////////
	//	Loop
	////////////////////////////////////////////////
	
	void setLoop(bool value);
	void setLoop(int value);
	bool getLoop();
	bool isLoop();
	Field *getLoopField();

	////////////////////////////////////////////////
	//	Cyble Interval
	////////////////////////////////////////////////
	
	void setCycleInterval(double value);
	double getCycleInterval();
	Field *getCycleIntervalField();

	////////////////////////////////////////////////
	//	Start time
	////////////////////////////////////////////////
	
	void setStartTime(double value);
	double getStartTime();
	Field *getStartTimeField();

	////////////////////////////////////////////////
	//	Stop time
	////////////////////////////////////////////////
	
	void setStopTime(double value);
	double getStopTime();
	Field *getStopTimeField();

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool  value);
	bool  getIsActive();
	bool  isActive();
	Field *getIsActiveField();

	////////////////////////////////////////////////
	//	fraction_changed
	////////////////////////////////////////////////
	
	void setFractionChanged(float value);
	float getFractionChanged();
	Field *getFractionChangedField();

	////////////////////////////////////////////////
	//	Cycle time
	////////////////////////////////////////////////
	
	void setCycleTime(double value);
	double getCycleTime();
	Field *getCycleTimeField();

	////////////////////////////////////////////////
	//	Time
	////////////////////////////////////////////////
	
	void setTime(double value);
	double getTime();
	Field *getTimeField();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	TimeSensorNode *next();
	TimeSensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	Virtual functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();
	void outputContext(ostream &printStream, String indentString);
};

#endif

