/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	TouchSensorNode.h
*
******************************************************************/

#ifndef _TOUCHSENSOR_H_
#define _TOUCHSENSOR_H_

#include "vrmlfields.h"
#include "Node.h"

class TouchSensorNode : public Node {
	
public:

	TouchSensorNode();
	~TouchSensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void setEnabled(bool value);
	void setEnabled(int value);
	bool getEnabled();
	bool isEnabled();
	SFBool *getEnabledField();

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool value);
	bool getIsActive();
	bool isActive();
	SFBool *getIsActiveField();

	////////////////////////////////////////////////
	//	isOver
	////////////////////////////////////////////////
	
	void setIsOver(bool  value);
	void setIsOver(int value);
	bool  getIsOver();
	bool  isOver();
	SFBool *getIsOverField();

	////////////////////////////////////////////////
	//	hitNormal
	////////////////////////////////////////////////
	
	void setHitNormalChanged(float value[]);
	void setHitNormalChanged(float x, float y, float z);
	void getHitNormalChanged(float value[]);
	SFVec3f *getHitNormalChanged();

	////////////////////////////////////////////////
	//	hitPoint
	////////////////////////////////////////////////
	
	void setHitPointChanged(float value[]);
	void setHitPointChanged(float x, float y, float z);
	void getHitPointChanged(float value[]);
	SFVec3f *getHitPointChanged();

	////////////////////////////////////////////////
	//	hitTexCoord
	////////////////////////////////////////////////
	
	void setHitTexCoord(float value[]);
	void setHitTexCoord(float x, float y);
	void getHitTexCoord(float value[]);
	SFVec2f *getHitTexCoord();

	////////////////////////////////////////////////
	//	ExitTime
	////////////////////////////////////////////////
	
	void setTouchTime(double value);
	double getTouchTime();
	SFTime *getTouchTimeField();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	TouchSensorNode *next();
	TouchSensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif
