/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ViewpointNode.h
*
******************************************************************/

#ifndef _VIEWPOINT_H_
#define _VIEWPOINT_H_

#include "BindableNode.h"

class ViewpointNode : public BindableNode {

public:

	ViewpointNode();
	~ViewpointNode();

	////////////////////////////////////////////////
	//	Jump
	////////////////////////////////////////////////
	
	void setJump(bool value);
	void setJump(int value);
	bool getJump();

	////////////////////////////////////////////////
	//	FieldOfView
	////////////////////////////////////////////////
	
	void setFieldOfView(float value);
	float getFieldOfView();

	////////////////////////////////////////////////
	//	Description
	////////////////////////////////////////////////
	
	void setDescription(String value);
	String getDescription();

	////////////////////////////////////////////////
	//	Position
	////////////////////////////////////////////////

	void setPosition(float value[]);
	void setPosition(float x, float y, float z);
	void getPosition(float value[]);
	SFVec3f *getPosition();

	////////////////////////////////////////////////
	//	Orientation
	////////////////////////////////////////////////

	void setOrientation(float value[]);
	void setOrientation(float x, float y, float z, float w);
	void getOrientation(float value[]);
	SFRotation *getOrientation();

	////////////////////////////////////////////////
	//	Add position
	////////////////////////////////////////////////

	void addPosition(float worldTranslation[3]); 
	void addPosition(float worldx, float worldy, float worldz); 
	void addPosition(float localTranslation[3], float frame[3][3]); 
	void addPosition(float x, float y, float z, float frame[3][3]); 

	////////////////////////////////////////////////
	//	Add orientation
	////////////////////////////////////////////////

	void addOrientation(SFRotation *rot);
	void addOrientation(float rotationValue[4]);
	void addOrientation(float x, float y, float z, float rot);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ViewpointNode *next();
	ViewpointNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream& printStream, String indentString);

	////////////////////////////////////////////////
	//	Local frame
	////////////////////////////////////////////////

	void getFrame(float frame[3][3]);
	void translate(float vector[3]);
	void translate(SFVec3f vec);
	void rotate(float rotation[4]);
	void rotate(SFRotation rot);

	////////////////////////////////////////////////
	//	ViewpointNode Matrix
	////////////////////////////////////////////////

	void getMatrix(SFMatrix *matrix);
	void getMatrix(float value[4][4]);
	void getTranslationMatrix(SFMatrix *matrix);
	void getTranslationMatrix(float value[4][4]);
};

#endif

