/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	VisibilitySensorNode.h
*
******************************************************************/

#ifndef _VISIBILITYSENSOR_H_
#define _VISIBILITYSENSOR_H_

#include "vrmlfields.h"
#include "Node.h"

class VisibilitySensorNode : public Node {

public:

	VisibilitySensorNode();
	~VisibilitySensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void	setEnabled(bool value);
	void	setEnabled(int value);
	bool	getEnabled();
	bool	isEnabled();

	////////////////////////////////////////////////
	//	Center
	////////////////////////////////////////////////
	
	void	setCenter(float value[]);
	void	setCenter(float x, float y, float z);
	void	getCenter(float value[]);

	////////////////////////////////////////////////
	//	Size
	////////////////////////////////////////////////
	
	void	setSize(float value[]);
	void	setSize(float x, float y, float z);
	void	getSize(float value[]);

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void	setIsActive(bool value);
	void	setIsActive(int value);
	bool	getIsActive();
	bool	isActive();

	////////////////////////////////////////////////
	//	EnterTime
	////////////////////////////////////////////////
	
	void	setEnterTime(double value);
	double	getEnterTime();

	////////////////////////////////////////////////
	//	ExitTime
	////////////////////////////////////////////////
	
	void	setExitTime(double value);
	double	getExitTime();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	VisibilitySensorNode *next();
	VisibilitySensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool	isChildNodeType(Node *node);
	void	initialize();
	void	uninitialize();
	void	update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void	outputContext(ostream &printStream, String indentString);
};

#endif

