/***************************************************************************
                          cconfig.h  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCONFIG_H
#define CCONFIG_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/cstring.h>
#include <dclib/clist.h>
#include <dclib/dcobject.h>
#include <dclib/cbytearray.h>
#include <dclib/cthread.h>
#include <dclib/cdownloadqueue.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

class DLL_EXPORT DCConfigHubItem : public CObject {
public:
	/** */
	DCConfigHubItem()
	{
		sName = sHost = sDescription = sUserCount = "";
	};
	/** */
	virtual ~DCConfigHubItem() {};

	/** hubname */
	CString sName;
	/** hub host */
	CString sHost;
	/** hub description */
	CString sDescription;
	/** user count */
	CString sUserCount;
};

class DLL_EXPORT DCConfigHubListUrl : public CObject {
public:
	/** */
	DCConfigHubListUrl() {};
	/** */
	virtual ~DCConfigHubListUrl() {};
	/** */
	CString sUrl;
	/** */
	bool bEnabled;
};

#ifdef WIN32
template class DLL_EXPORT CList<DCConfigHubItem>;
template class DLL_EXPORT CList<DCConfigHubListUrl>;
#endif

class CStringList;

class DLL_EXPORT CConfig : public CObject {

public:
	/** */
	CConfig( CString configpath = "");
	/** */
	virtual ~CConfig();

	/** */
	int LoadDCLib();
	/** */
	int SaveDCLib();
	/** */
	void ParseDCLibConfig( xmlNodePtr node );

	/** */
	int LoadDCTra( CStringList * queue, CStringList * chunks );
	/** */
	int SaveDCTra( CStringList * queue, CStringList * chunks );

	/** */
	int LoadDCShare( CThreadStringList * share );
	/** */
	int SaveDCShare( CThreadStringList * share );

	/** */
	CString ParseVersion( CString s );
	/** */
	CString GetTCPHostString();
	/** */
	CString GetUDPHostString();

	/** */
	void CreateShareList();
	/** */
	ulonglong GetShareSize() const;
	/** */
	long GetShareBufferSize() const;
	/** */
	int GetShareBuffer( CByteArray * sharebuffer );

	/** */
	int GetDownloadQueueTime() const;
	/** */
	void SetDownloadQueueTime( int i );

	/** */
	CString GetEMail( bool raw = FALSE );
	/** */
	void SetEMail( CString email );
	/** */
	CString GetNick() const;
	/** */
	void SetNick( CString nick );
	/** */
	CString GetDownloadFolder() const;
	/** */
	void SetDownloadFolder( CString downloadfolder );
	/** */
	CString GetDownloadFinishedFolder() const;
	/** */
	void SetDownloadFinishedFolder( CString s );

	/** */
	eClientMode GetMode() const;
	/** */
	void SetMode( eClientMode mode );
	/** */
	CString GetDescription() const;
	/** */
	void SetDescription( CString description );
	/** */
	CString GetSpeed() const;
	/** */
	void SetSpeed( CString speed );
	/** */
	int GetTCPListenPort() const;
	/** */
	void SetTCPListenPort( int port );
	/** */
	int GetUDPListenPort() const;
	/** */
	void SetUDPListenPort( int port );
	/** */
	CString GetHost() const;
	/** */
	void SetHost( CString host );
	/** */
	CString GetInterface() const;
	/** */
	void SetInterface( CString iface );
	/** */
	bool GetAntiSpam() const;
	/** */
	void SetAntiSpam( bool antispam );
	/** */
	int GetFakeHost() const;
	/** */
	void SetFakeHost( int fakehost );
	/** */
	int GetMaxUpload() const;
	/** */
	void SetMaxUpload( int maxupload );
	/** */
	void SetAwayMode( eUserAwayMode mode );
	/** */
	eUserAwayMode GetAwayMode() const;
	/** */
	long GetSharedFolders( CList<CString> * list );
	/** */
	void SetSharedFolders( CList<CString> * list );
	/** */
	bool GetSendMessageOnActiveModeRequest() const;
	/** */
	void SetSendMessageOnActiveModeRequest( bool b );

	/** */
	int LoadDCHub();
	/** */
	int SaveDCHub();
	/** */
	int SaveDCPublicHub();
	/** */
	int SaveDCBookHub();
	/** */
	void ParseDCHubConfig( xmlNodePtr node );
	/** */
	void ParseDCBookHubConfig( xmlNodePtr node );
	/** */
	long GetBookmarkHubList( CList<DCConfigHubItem> * list );
	/** */
	bool RemoveBookmarkHub( CString name, CString host, CString description );
	/** */
	bool AddBookmarkHub( CString name, CString host, CString description );
	/** */
	bool UpdateBookmarkHub( CString name, CString host, CString description );
	/** */
	long GetPublicHubList( CList<DCConfigHubItem> * list );
	/** */
	bool GetBookmarkHub( CString name, DCConfigHubItem * hubitem );
	/** */
	bool GetPublicHub( CString name, DCConfigHubItem * hubitem );
	/** */
	bool RemovePublicHub( CString name, CString host, CString description );
	/** */
	bool AddPublicHub( const CString name, const CString host, const CString description, const CString usercount );
	/** */
	void ClearPublicHubList();
	/** */
	long GetHubListUrlList( CList<DCConfigHubListUrl> * list );
	/** */
	void SetHubListUrlList( CList<DCConfigHubListUrl> * list );

	/** */
	bool GetHubListStoreLocal() const;
	/** */
	void SetHubListStoreLocal( bool b );
	/** */
	int GetReconnectCount() const;
	/** */
	void SetReconnectCount( int reconnectcount );
	/** */
	int GetReconnectTimeout() const;
	/** */
	void SetReconnectTimeout( int reconnecttimeout );

	/** */
	int GetTransferResendTimeout() const;
	/** */
	void SetTransferResendTimeout( int i );
	/** */
	int GetTransferResponseTimeout() const;
	/** */
	void SetTransferResponseTimeout( int i );

	/** */
	bool GetForceMoveEnabled() const;
	/** */
	void SetForceMoveEnabled( bool forcemoveenabled );

	/** */
	long GetMaxTransferrate() const;
	/** */
	void SetMaxTransferrate( long transferrate );

private:

	/** */
	CString sEMail;
	/** */
	CString sNick;
	/** */
	CString sDownloadFolder;
	/** */
	CString sDownloadFinishedFolder;
	/** */
	eClientMode eMode;
	/** */
	CString sDescription;
	/** */
	CString sSpeed;
	/** */
	int iTCPListenPort;
	/** */
	int iUDPListenPort;
	/** */
	CString sHost;
	/** */
	CString sInterface;
	/** */
	bool bAntiSpam;
	/** */
	int iFakeHost;
	/** */
	bool bSendMessageOnActiveModeRequest;
	/** */
	int iMaxUpload;
	/** */
	long lMaxTransferrate;
	/** */
	int iReconnectCount;
	/** */
	int iReconnectTimeout;
	/** */
	int iTransferResendTimeout;
	/** */
	int iTransferResponseTimeout;
	/** */
	bool bForceMoveEnabled;
	/** */
	bool bHubListStoreLocal;
	/** */
	eUserAwayMode eAwayMode;
	/** */
	CList<CString> SharedFolders;
	/** */
	ulonglong iShareSize;
	/** */
	CByteArray * pShareBuffer;
	/** */
	CStringList * pBookmarkHubList;
	/** */
	CStringList * pPublicHubList;
	/** */
	CList<DCConfigHubListUrl> pHubListUrlList;
	/** */
	CString sShareBuffer;
	/** */
	int iDownloadQueueTime;

protected:
	/** */
	void CreateShareList( int depth, CString base, CString curr, CString relpath );
	/** */
	CThread Thread;
	/** */
	CString sConfigPath;
};

/** inline functions */

/** */
inline void CConfig::SetEMail( CString email )
{ Thread.Lock(); sEMail = email; Thread.UnLock(); }
/** */
inline CString CConfig::GetNick() const
{ return sNick; }
/** */
inline void CConfig::SetNick( CString nick )
{ Thread.Lock(); sNick = nick; Thread.UnLock(); }
/** */
inline CString CConfig::GetDownloadFolder() const
{ return sDownloadFolder; }
/** */
inline void CConfig::SetDownloadFolder( CString downloadfolder )
{ Thread.Lock(); sDownloadFolder = downloadfolder; Thread.UnLock(); }
/** */
inline CString CConfig::GetDownloadFinishedFolder() const
{ return sDownloadFinishedFolder; }
/** */
inline void CConfig::SetDownloadFinishedFolder( CString s )
{ Thread.Lock(); sDownloadFinishedFolder = s; Thread.UnLock(); }
/** */
inline eClientMode CConfig::GetMode() const
{ return eMode; }
/** */
inline void CConfig::SetMode( eClientMode mode )
{ Thread.Lock(); eMode = mode; Thread.UnLock(); }
/** */
inline CString CConfig::GetDescription() const
{ return sDescription; }
/** */
inline void CConfig::SetDescription( CString description )
{ Thread.Lock(); sDescription = description; Thread.UnLock(); }
/** */
inline CString CConfig::GetSpeed() const
{ return sSpeed; }
/** */
inline void CConfig::SetSpeed( CString speed )
{ Thread.Lock(); sSpeed = speed; Thread.UnLock(); }
/** */
inline int CConfig::GetTCPListenPort() const
{ return iTCPListenPort; }
/** */
inline void CConfig::SetTCPListenPort( int port )
{ Thread.Lock(); iTCPListenPort = port; Thread.UnLock(); }
/** */
inline int CConfig::GetUDPListenPort() const
{ return iUDPListenPort; }
/** */
inline void CConfig::SetUDPListenPort( int port )
{ Thread.Lock(); iUDPListenPort = port; Thread.UnLock(); }
/** */
inline CString CConfig::GetHost() const
{ return sHost; }
/** */
inline void CConfig::SetHost( CString host )
{ Thread.Lock(); sHost = host; Thread.UnLock(); }
/** */
inline CString CConfig::GetInterface() const
{ return sInterface; }
/** */
inline void CConfig::SetInterface( CString iface )
{ Thread.Lock(); sInterface = iface; Thread.UnLock(); }
/** */
inline bool CConfig::GetAntiSpam() const
{ return bAntiSpam; }
/** */
inline void CConfig::SetAntiSpam( bool antispam )
{ Thread.Lock(); bAntiSpam = antispam; Thread.UnLock(); }
/** */
inline int CConfig::GetFakeHost() const
{ return iFakeHost; }
/** */
inline void CConfig::SetFakeHost( int fakehost )
{ Thread.Lock(); iFakeHost = fakehost; Thread.UnLock(); }
/** */
inline int CConfig::GetMaxUpload() const
{ return iMaxUpload; }
/** */
inline void CConfig::SetMaxUpload( int maxupload )
{ Thread.Lock(); iMaxUpload = maxupload; Thread.UnLock(); }
/** */
inline ulonglong CConfig::GetShareSize() const
{ return iShareSize; }
/** */
inline long CConfig::GetShareBufferSize() const
{ if (pShareBuffer) return pShareBuffer->Size(); else return 0; }
/** */
inline void CConfig::ClearPublicHubList()
{ Thread.Lock(); pPublicHubList->Clear(); Thread.UnLock(); }
/** */
inline long CConfig::GetMaxTransferrate() const
{ return lMaxTransferrate; }
/** */
inline void CConfig::SetMaxTransferrate( long transferrate )
{ Thread.Lock(); lMaxTransferrate = transferrate; Thread.UnLock(); }
/** */
inline bool CConfig::GetHubListStoreLocal() const
{ return bHubListStoreLocal; }
/** */
inline void CConfig::SetHubListStoreLocal( bool b )
{ Thread.Lock(); bHubListStoreLocal = b; Thread.UnLock(); }
/** */
inline int CConfig::GetReconnectCount() const
{ return iReconnectCount; }
/** */
inline void CConfig::SetReconnectCount( int reconnectcount )
{ Thread.Lock(); iReconnectCount = reconnectcount; Thread.UnLock(); }
/** */
inline int CConfig::GetReconnectTimeout() const
{ return iReconnectTimeout; }
/** */
inline void CConfig::SetReconnectTimeout( int reconnecttimeout )
{ Thread.Lock(); iReconnectTimeout = reconnecttimeout; Thread.UnLock(); }
/** */
inline int CConfig::GetTransferResendTimeout() const
{ return iTransferResendTimeout; }
/** */
inline void CConfig::SetTransferResendTimeout( int i )
{ Thread.Lock(); iTransferResendTimeout = i; Thread.UnLock(); }
/** */
inline int CConfig::GetTransferResponseTimeout() const
{ return iTransferResponseTimeout; }
/** */
inline void CConfig::SetTransferResponseTimeout( int i )
{ Thread.Lock(); iTransferResponseTimeout = i; Thread.UnLock(); }
/** */
inline bool CConfig::GetForceMoveEnabled() const
{ return bForceMoveEnabled; }
/** */
inline void CConfig::SetForceMoveEnabled( bool forcemoveenabled )
{ Thread.Lock(); bForceMoveEnabled = forcemoveenabled; Thread.UnLock(); }
/** */
inline void CConfig::SetAwayMode( eUserAwayMode mode )
{ Thread.Lock(); eAwayMode = mode; Thread.UnLock(); }
/** */
inline eUserAwayMode CConfig::GetAwayMode() const
{ return eAwayMode; }
/** */
inline int CConfig::GetDownloadQueueTime() const
{ return iDownloadQueueTime; };
/** */
inline void CConfig::SetDownloadQueueTime( int i )
{ Thread.Lock(); iDownloadQueueTime = i; Thread.UnLock(); }
/** */
inline bool CConfig::GetSendMessageOnActiveModeRequest() const
{ return bSendMessageOnActiveModeRequest; }
/** */
inline void CConfig::SetSendMessageOnActiveModeRequest( bool b )
{ Thread.Lock(); bSendMessageOnActiveModeRequest = b; Thread.UnLock(); }

extern CConfig * pDCLibConfig;
#endif
