/***************************************************************************
                          cconnection.h  -  description
                             -------------------
    begin                : Sat Oct 6 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCONNECTION_H
#define CCONNECTION_H

#include <dclib/dcos.h>
#include <dclib/cthread.h>
#include <dclib/csocket.h>
#include <dclib/dcobject.h>
#include <dclib/clist.h>

/**
  *@author Mathias Kster
  */

class DLL_EXPORT CConnection : public CThread, public CSocket {
public: 
	CConnection();
	virtual ~CConnection();

	/** */
	int Connect();
	/** */
	int Connect( CString ip, int port = 411, eSocketType sockettype = estTCP );
	/** */
	int Disconnect( bool force = FALSE );
	/** */
	int SetSocket( int handle, eSocketType sockettype = estTCP );

	/** */
	virtual void DataAvailable( const char *, int ) {};
	/** */
	virtual void DataSend() {};
	/** */
	virtual void DataTimeout() {};
	/** */
	virtual void ConnectionState( eConnectionState ) {};
	/** */
	virtual void Thread( CObject * Object );

	/** chat message */
	int SendChat( CString sNick, CString s );
	/** send version info */
	int SendVersion( CString sVersion );
	/** send myinfo */
	int SendMyInfo( CString sNick, CString sComment, CString sConnectionType, eUserAwayMode eAwayMode, CString sEMail, CString sShare );
	/** send key */
	int SendKey( CString s );
	/** send validate nick */
	int SendValidateNick( CString sNick );
	/** send lock */
	int SendLock();
	/** send send */
	int SendSend();
	/** send my nick */
	int SendMyNick( CString sNick );
	/** send get */
	int SendGet( CString file, ulonglong pos );
	/** send direction */
	int SendDirection( eDirection Direction, int level );
	/** send private message */
	int SendPrivateMessage( CString sNick, CString sTo, CString sMsg );
	/** send request nick list */
	int RequestNickList();
	/** send rev connect to me */
	int SendRevConnectToMe( CString sNick, CString sDstNick );
	/** send error */
	int SendError( CString message );
	/** */
	int SendFileLength( ulonglong len );
	/** */
	int SendListLen( ulonglong len );
	/** */
	int SendGetListLen();
	/** */
	int SendConnectToMe( CString sDstNick, CString host );
	/** */
	int SendCanceled();
	/** send string */
	int SendString( CString message );
	/** send password */
	int SendPass( CString pass );
	/** operator kick */
	int SendKick( CString nick );
	/** operator force move a user */
	int SendOpForceMove( CString nick, CString host, CString message );
	/** */
	int SendMaxedOut();
	/** */
	int SendGetInfo( CString sNick, CString sMyNick );

	/** */
	void SetHost( CString ip, int port = 411 );
	/** */
	CString GetHost();
	/** */
	CString GetIP() const;
	/** */
	int GetPort() const;
	/** */
	eConnectionState GetConnectionState() const;

protected:
	/** */
	eConnectionState eState;
	/** check for connection/data timeout */
	time_t timeConnection;

private:
	/** */
	CThread _mutex;
	/** */
	bool bForceDisconnect;
	/** */
	CString sIP;
	/** */
	int iPort;
	/** */
	CList<CObject> * pSendList;
	/** */
	char * pBuffer;
	/** */
	int iConnectTimeout;
	/** */
	CThread ConnectionThread;
	/** */
	void StateConnect();
	/** */
	void StateConnecting();
	/** */
	void StateRead();
	/** */
	void StateSend();
	/** */
	void StateDisconnect();
	/** */
	int Write( const char * buffer, int len );
};

/** inline functions */

/** */
inline void CConnection::SetHost( CString ip, int port )
{ sIP=ip;iPort=port; }
/** */
inline CString CConnection::GetIP() const
{ return sIP; }
/** */
inline int CConnection::GetPort() const
{ return iPort; }
/** */
inline eConnectionState CConnection::GetConnectionState() const
{ return eState; }

#endif
